/*
 * Decompiled with CFR 0.152.
 */
package me.everything.providers.core;

import android.content.ContentValues;
import android.database.Cursor;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.everything.providers.core.EnumInt;
import me.everything.providers.core.FieldMapping;
import me.everything.providers.core.IgnoreMapping;

public abstract class Entity {
    public static <T> String[] getColumns(Class<T> cls) {
        Field[] fields;
        ArrayList<String> columns = new ArrayList<String>();
        for (Field field : fields = cls.getDeclaredFields()) {
            FieldMapping contentField;
            if (field.isAnnotationPresent(IgnoreMapping.class) || (contentField = field.getAnnotation(FieldMapping.class)) == null) continue;
            String columnName = contentField.columnName();
            columns.add(columnName);
        }
        return columns.toArray(new String[columns.size()]);
    }

    public static <T> String[] getWriteColumns(Class<T> cls) {
        Field[] fields;
        ArrayList<String> columns = new ArrayList<String>();
        for (Field field : fields = cls.getDeclaredFields()) {
            FieldMapping contentField;
            if (field.isAnnotationPresent(IgnoreMapping.class) || !(contentField = field.getAnnotation(FieldMapping.class)).canUpdate()) continue;
            String columnName = contentField.columnName();
            columns.add(columnName);
        }
        return columns.toArray(new String[columns.size()]);
    }

    public static Long getId(Entity entity) {
        return Long.valueOf(String.valueOf(Entity.getColumnValue("_id", entity)));
    }

    public static Object getColumnValue(String columnName, Entity entity) {
        try {
            Field field = Entity.getColumnField(columnName, entity);
            if (field != null) {
                return field.get(entity);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getColumnValue(Field field, Entity entity) {
        try {
            return field.get(entity);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field getColumnField(String columnName, Entity entity) {
        Field[] fields;
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            FieldMapping contentField;
            if (field.isAnnotationPresent(IgnoreMapping.class) || !(contentField = field.getAnnotation(FieldMapping.class)).columnName().equals(columnName)) continue;
            return field;
        }
        return null;
    }

    public static ContentValues getContentValues(String[] columns, Entity entity) {
        ContentValues contentValues = new ContentValues();
        block6: for (String column : columns) {
            Field field = Entity.getColumnField(column, entity);
            FieldMapping fieldMapping = field.getAnnotation(FieldMapping.class);
            Object value = Entity.getColumnValue(field, entity);
            if (fieldMapping == null) continue;
            FieldMapping.PhysicalType physicalType = fieldMapping.physicalType();
            switch (physicalType) {
                case Int: {
                    contentValues.put(column, Integer.valueOf(String.valueOf(value)));
                    continue block6;
                }
                case String: {
                    contentValues.put(column, String.valueOf(value));
                    continue block6;
                }
                case Long: {
                    contentValues.put(column, Long.valueOf(String.valueOf(value)));
                    continue block6;
                }
                case Double: {
                    contentValues.put(column, Double.valueOf(String.valueOf(value)));
                    continue block6;
                }
            }
        }
        return contentValues;
    }

    public static List<Object> getFlattenedValues(String[] columns, Entity entity) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : columns) {
            Field field = Entity.getColumnField(column, entity);
            Object value = Entity.getColumnValue(field, entity);
            if (value instanceof EnumInt) {
                value = String.valueOf(value);
            }
            values.add(value);
        }
        return values;
    }

    public static <T extends Entity> T create(Cursor cursor, Class<T> cls) {
        try {
            Entity entity = (Entity)cls.newInstance();
            Field[] fields = cls.getDeclaredFields();
            return (T)Entity.create(entity, cursor, cls, fields);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T create(Cursor cursor, Class<T> cls, String ... projection) {
        try {
            Entity entity = (Entity)cls.newInstance();
            Field[] fields = new Field[projection.length];
            int size = projection.length;
            for (int i = 0; i < size; ++i) {
                fields[i] = Entity.getColumnField(projection[i], entity);
            }
            return (T)Entity.create(entity, cursor, cls, fields);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T create(T entity, Cursor cursor, Class<T> cls, Field[] fields) {
        for (Field field : fields) {
            try {
                FieldMapping contentField = field.getAnnotation(FieldMapping.class);
                IgnoreMapping ignoreMapping = field.getAnnotation(IgnoreMapping.class);
                if (contentField == null || ignoreMapping != null) continue;
                String columnName = contentField.columnName();
                String methodName = "get" + contentField.physicalType().name();
                Method method = Cursor.class.getDeclaredMethod(methodName, Integer.TYPE);
                int columnIndex = cursor.getColumnIndexOrThrow(columnName);
                Object object = method.invoke((Object)cursor, columnIndex);
                switch (contentField.logicalType()) {
                    case Boolean: {
                        boolean value = Integer.valueOf(String.valueOf(object)) != 0;
                        field.setAccessible(true);
                        field.setBoolean(entity, value);
                        break;
                    }
                    case EnumInt: {
                        Class<?> enumType = field.getType();
                        Method enumStaticMethod = enumType.getMethod("fromVal", Integer.TYPE);
                        Object enumInstance = enumStaticMethod.invoke(null, object);
                        field.setAccessible(true);
                        field.set(entity, enumInstance);
                        break;
                    }
                    case Array: {
                        String[] strings = String.valueOf(object).split(contentField.splitRegex());
                        field.setAccessible(true);
                        field.set(entity, strings);
                        break;
                    }
                    default: {
                        field.setAccessible(true);
                        field.set(entity, object);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)Entity.class.getName(), (String)("field=" + field.getName()), (Throwable)e);
            }
        }
        return entity;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        Field[] fields = this.getClass().getDeclaredFields();
        boolean firstTime = true;
        for (Field field : fields) {
            try {
                if (!firstTime) {
                    stringBuilder.append(", ");
                }
                field.setAccessible(true);
                stringBuilder.append(field.getName());
                stringBuilder.append("=");
                stringBuilder.append(field.get(this));
                firstTime = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

