/*
 * Decompiled with CFR 0.152.
 */
package me.everything.providers.core;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import me.everything.providers.core.Data;
import me.everything.providers.core.Entity;

public abstract class AbstractProvider {
    protected String TAG = this.getClass().getName();
    private ContentResolver mContentResolver;

    protected AbstractProvider(Context context) {
        this.mContentResolver = context.getContentResolver();
    }

    public void registerContentObserver(Uri uri, ContentObserver observer) {
        this.mContentResolver.registerContentObserver(uri, false, observer);
    }

    protected <T extends Entity> Data<T> getContentTableData(Uri uri, Class<T> cls) {
        Cursor cursor = this.mContentResolver.query(uri, Entity.getColumns(cls), null, null, null);
        if (cursor == null) {
            return null;
        }
        Data<T> data = new Data<T>(cursor, cls);
        return data;
    }

    protected <T extends Entity> Data<T> getContentTableData(Uri uri, String selection, String[] selectionArgs, String sortOrder, Class<T> cls) {
        Cursor cursor = this.mContentResolver.query(uri, Entity.getColumns(cls), selection, selectionArgs, sortOrder);
        if (cursor == null) {
            return null;
        }
        Data<T> data = new Data<T>(cursor, cls);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Entity> T getContentRowData(Uri uri, String selection, String[] selectionArgs, String sortOrder, Class<T> cls) {
        T t = null;
        Cursor cursor = this.mContentResolver.query(uri, Entity.getColumns(cls), selection, selectionArgs, sortOrder);
        if (cursor == null) {
            return null;
        }
        try {
            if (cursor.moveToNext()) {
                t = Entity.create(cursor, cls);
            }
        }
        finally {
            cursor.close();
        }
        return t;
    }

    protected int updateTableRow(Uri uri, Entity entity) {
        String[] columns;
        Long id = Entity.getId(entity);
        if (id != null && (columns = Entity.getWriteColumns(entity.getClass())) != null && columns.length > 0) {
            ContentValues values = Entity.getContentValues(columns, entity);
            Uri updateUri = ContentUris.withAppendedId((Uri)uri, (long)id);
            int rows = this.mContentResolver.update(updateUri, values, null, null);
            return rows;
        }
        return 0;
    }
}

