/*
 * Decompiled with CFR 0.152.
 */
package me.everything.providers.android.telephony;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import me.everything.providers.android.telephony.Carrier;
import me.everything.providers.android.telephony.Conversation;
import me.everything.providers.android.telephony.Mms;
import me.everything.providers.android.telephony.Sms;
import me.everything.providers.android.telephony.Thread;
import me.everything.providers.core.AbstractProvider;
import me.everything.providers.core.Data;

@TargetApi(value=19)
public class TelephonyProvider
extends AbstractProvider {
    public TelephonyProvider(Context context) {
        super(context);
    }

    public Data<Sms> getSms(Filter filter) {
        Uri uri = null;
        switch (filter) {
            case ALL: {
                uri = Sms.uri;
                break;
            }
            case INBOX: {
                uri = Sms.uriInbox;
                break;
            }
            case OUTBOX: {
                uri = Sms.uriOutbox;
                break;
            }
            case SENT: {
                uri = Sms.uriSent;
                break;
            }
            case DRAFT: {
                uri = Sms.uriDraft;
            }
        }
        Data sms = this.getContentTableData(uri, Sms.class);
        return sms;
    }

    public Data<Mms> getMms(Filter filter) {
        Uri uri = null;
        switch (filter) {
            case ALL: {
                uri = Mms.uri;
                break;
            }
            case INBOX: {
                uri = Mms.uriInbox;
                break;
            }
            case OUTBOX: {
                uri = Mms.uriOutbox;
                break;
            }
            case SENT: {
                uri = Mms.uriSent;
                break;
            }
            case DRAFT: {
                uri = Mms.uriDraft;
            }
        }
        Data Mms2 = this.getContentTableData(uri, Mms.class);
        return Mms2;
    }

    public Data<Conversation> getConversations() {
        Data conversations = this.getContentTableData(Conversation.uri, Conversation.class);
        return conversations;
    }

    public Data<Thread> getThreads() {
        Data threads = this.getContentTableData(Thread.uri, Thread.class);
        return threads;
    }

    public Data<Carrier> getCarriers() {
        Data carriers = this.getContentTableData(Carrier.uri, Carrier.class);
        return carriers;
    }

    public static enum Filter {
        ALL,
        INBOX,
        OUTBOX,
        SENT,
        DRAFT;

    }
}

