/*
 * Decompiled with CFR 0.152.
 */
package me.everything.providers.android.calendar;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.net.Uri;
import me.everything.providers.android.calendar.Attendee;
import me.everything.providers.android.calendar.Calendar;
import me.everything.providers.android.calendar.Event;
import me.everything.providers.android.calendar.Instance;
import me.everything.providers.android.calendar.Reminder;
import me.everything.providers.core.AbstractProvider;
import me.everything.providers.core.Data;

@TargetApi(value=14)
public class CalendarProvider
extends AbstractProvider {
    public CalendarProvider(Context context) {
        super(context);
    }

    public Data<Calendar> getCalendars() {
        Data calendars = this.getContentTableData(Calendar.uri, Calendar.class);
        return calendars;
    }

    public Calendar getCalendar(long calendarId) {
        String selection = "(_id = ?)";
        String[] selectionArgs = new String[]{String.valueOf(calendarId)};
        Calendar calendar = (Calendar)this.getContentRowData(Calendar.uri, selection, selectionArgs, null, Calendar.class);
        return calendar;
    }

    public Data<Event> getEvents(long calendarId) {
        String selection = "(calendar_id = ?)";
        String[] selectionArgs = new String[]{String.valueOf(calendarId)};
        Data events = this.getContentTableData(Event.uri, selection, selectionArgs, null, Event.class);
        return events;
    }

    public Event getEvent(long eventId) {
        String selection = "(_id = ?)";
        String[] selectionArgs = new String[]{String.valueOf(eventId)};
        Event event = (Event)this.getContentRowData(Event.uri, selection, selectionArgs, null, Event.class);
        return event;
    }

    public Data<Instance> getInstances(long begin, long end) {
        Uri.Builder builder = Instance.uri.buildUpon();
        ContentUris.appendId((Uri.Builder)builder, (long)begin);
        ContentUris.appendId((Uri.Builder)builder, (long)end);
        Uri uri = builder.build();
        Data instances = this.getContentTableData(uri, Instance.class);
        return instances;
    }

    public Data<Instance> getInstances(long eventId, long begin, long end) {
        String selection = "(event_id = ?)";
        String[] selectionArgs = new String[]{String.valueOf(eventId)};
        Uri.Builder builder = Instance.uri.buildUpon();
        ContentUris.appendId((Uri.Builder)builder, (long)begin);
        ContentUris.appendId((Uri.Builder)builder, (long)end);
        Uri uri = builder.build();
        Data instances = this.getContentTableData(uri, selection, selectionArgs, null, Instance.class);
        return instances;
    }

    public Data<Attendee> getAttendees(long eventId) {
        String selection = "(event_id=?)";
        String[] selectionArgs = new String[]{Long.toString(eventId)};
        Data attendees = this.getContentTableData(Attendee.uri, selection, selectionArgs, null, Attendee.class);
        return attendees;
    }

    public Data<Reminder> getReminders(long eventId) {
        String selection = "(event_id=?)";
        String[] selectionArgs = new String[]{Long.toString(eventId)};
        Data reminders = this.getContentTableData(Reminder.uri, selection, selectionArgs, null, Reminder.class);
        return reminders;
    }

    public int update(Calendar calendar) {
        return this.updateTableRow(Calendar.uri, calendar);
    }

    public int update(Event event) {
        return this.updateTableRow(Event.uri, event);
    }

    public int update(Instance instance) {
        return this.updateTableRow(Instance.uri, instance);
    }

    public int update(Reminder reminder) {
        return this.updateTableRow(Reminder.uri, reminder);
    }

    public int update(Attendee attendee) {
        return this.updateTableRow(Attendee.uri, attendee);
    }
}

