/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll.adapters;

import android.support.v4.view.ViewPager;
import android.view.View;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public class ViewPagerOverScrollDecorAdapter
implements IOverScrollDecoratorAdapter,
ViewPager.OnPageChangeListener {
    protected final ViewPager mViewPager;
    protected int mLastPagerPosition = 0;
    protected float mLastPagerScrollOffset;

    public ViewPagerOverScrollDecorAdapter(ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mLastPagerPosition = this.mViewPager.getCurrentItem();
        this.mLastPagerScrollOffset = 0.0f;
    }

    @Override
    public View getView() {
        return this.mViewPager;
    }

    @Override
    public boolean isInAbsoluteStart() {
        return this.mLastPagerPosition == 0 && this.mLastPagerScrollOffset == 0.0f;
    }

    @Override
    public boolean isInAbsoluteEnd() {
        return this.mLastPagerPosition == this.mViewPager.getAdapter().getCount() - 1 && this.mLastPagerScrollOffset == 0.0f;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mLastPagerPosition = position;
        this.mLastPagerScrollOffset = positionOffset;
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
    }
}

