/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll;

import android.view.MotionEvent;
import android.view.View;
import me.everything.android.ui.overscroll.OverScrollBounceEffectDecoratorBase;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public class VerticalOverScrollBounceEffectDecorator
extends OverScrollBounceEffectDecoratorBase {
    public VerticalOverScrollBounceEffectDecorator(IOverScrollDecoratorAdapter viewAdapter) {
        this(viewAdapter, 3.0f, 1.0f, -2.0f);
    }

    public VerticalOverScrollBounceEffectDecorator(IOverScrollDecoratorAdapter viewAdapter, float touchDragRatioFwd, float touchDragRatioBck, float decelerateFactor) {
        super(viewAdapter, decelerateFactor, touchDragRatioFwd, touchDragRatioBck);
    }

    @Override
    protected OverScrollBounceEffectDecoratorBase.MotionAttributes createMotionAttributes() {
        return new MotionAttributesVertical();
    }

    @Override
    protected OverScrollBounceEffectDecoratorBase.AnimationAttributes createAnimationAttributes() {
        return new AnimationAttributesVertical();
    }

    @Override
    protected void translateView(View view, float offset) {
        view.setTranslationY(offset);
    }

    @Override
    protected void translateViewAndEvent(View view, float offset, MotionEvent event) {
        view.setTranslationY(offset);
        event.offsetLocation(offset - event.getY(0), 0.0f);
    }

    protected static class AnimationAttributesVertical
    extends OverScrollBounceEffectDecoratorBase.AnimationAttributes {
        public AnimationAttributesVertical() {
            this.mProperty = View.TRANSLATION_Y;
        }

        @Override
        protected void init(View view) {
            this.mAbsOffset = view.getTranslationY();
            this.mMaxOffset = view.getHeight();
        }
    }

    protected static class MotionAttributesVertical
    extends OverScrollBounceEffectDecoratorBase.MotionAttributes {
        protected MotionAttributesVertical() {
        }

        @Override
        public boolean init(View view, MotionEvent event) {
            if (event.getHistorySize() == 0) {
                return false;
            }
            float dy = event.getY(0) - event.getHistoricalY(0, 0);
            float dx = event.getX(0) - event.getHistoricalX(0, 0);
            if (Math.abs(dx) > Math.abs(dy)) {
                return false;
            }
            this.mAbsOffset = view.getTranslationY();
            this.mDeltaOffset = dy;
            this.mDir = this.mDeltaOffset > 0.0f;
            return true;
        }
    }
}

