/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll.adapters;

import android.view.View;
import android.widget.AbsListView;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public class AbsListViewOverScrollDecorAdapter
implements IOverScrollDecoratorAdapter {
    protected final AbsListView mView;

    public AbsListViewOverScrollDecorAdapter(AbsListView view) {
        this.mView = view;
    }

    @Override
    public View getView() {
        return this.mView;
    }

    @Override
    public boolean isInAbsoluteStart() {
        return this.mView.getChildCount() > 0 && !this.canScrollListUp();
    }

    @Override
    public boolean isInAbsoluteEnd() {
        return this.mView.getChildCount() > 0 && !this.canScrollListDown();
    }

    public boolean canScrollListUp() {
        int firstTop = this.mView.getChildAt(0).getTop();
        int firstPosition = this.mView.getFirstVisiblePosition();
        return firstPosition > 0 || firstTop < this.mView.getListPaddingTop();
    }

    public boolean canScrollListDown() {
        int childCount = this.mView.getChildCount();
        int itemsCount = this.mView.getCount();
        int firstPosition = this.mView.getFirstVisiblePosition();
        int lastPosition = firstPosition + childCount;
        int lastBottom = this.mView.getChildAt(childCount - 1).getBottom();
        return lastPosition < itemsCount || lastBottom > this.mView.getHeight() - this.mView.getListPaddingBottom();
    }
}

