/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.HorizontalScrollView;
import android.widget.ListView;
import android.widget.ScrollView;
import me.everything.android.ui.overscroll.HorizontalOverScrollBounceEffectDecorator;
import me.everything.android.ui.overscroll.VerticalOverScrollBounceEffectDecorator;
import me.everything.android.ui.overscroll.adapters.AbsListViewOverScrollDecorAdapter;
import me.everything.android.ui.overscroll.adapters.HorizontalScrollViewOverScrollDecorAdapter;
import me.everything.android.ui.overscroll.adapters.RecyclerViewOverScrollDecorAdapter;
import me.everything.android.ui.overscroll.adapters.ScrollViewOverScrollDecorAdapter;
import me.everything.android.ui.overscroll.adapters.StaticOverScrollDecorAdapter;

public class OverScrollDecoratorHelper {
    public static final int ORIENTATION_VERTICAL = 0;
    public static final int ORIENTATION_HORIZONTAL = 1;

    public static void setUpOverScroll(RecyclerView recyclerView, int orientation) {
        switch (orientation) {
            case 1: {
                new HorizontalOverScrollBounceEffectDecorator(new RecyclerViewOverScrollDecorAdapter(recyclerView));
                break;
            }
            case 0: {
                new VerticalOverScrollBounceEffectDecorator(new RecyclerViewOverScrollDecorAdapter(recyclerView));
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation");
            }
        }
    }

    public static void setUpOverScroll(ListView listView) {
        new VerticalOverScrollBounceEffectDecorator(new AbsListViewOverScrollDecorAdapter((AbsListView)listView));
    }

    public static void setUpOverScroll(GridView gridView) {
        new VerticalOverScrollBounceEffectDecorator(new AbsListViewOverScrollDecorAdapter((AbsListView)gridView));
    }

    public static void setUpOverScroll(ScrollView scrollView) {
        new VerticalOverScrollBounceEffectDecorator(new ScrollViewOverScrollDecorAdapter(scrollView));
    }

    public static void setUpOverScroll(HorizontalScrollView scrollView) {
        new HorizontalOverScrollBounceEffectDecorator(new HorizontalScrollViewOverScrollDecorAdapter(scrollView));
    }

    public static void setUpStaticOverScroll(View view, int orientation) {
        switch (orientation) {
            case 1: {
                new HorizontalOverScrollBounceEffectDecorator(new StaticOverScrollDecorAdapter(view));
                break;
            }
            case 0: {
                new VerticalOverScrollBounceEffectDecorator(new StaticOverScrollDecorAdapter(view));
                break;
            }
            default: {
                new IllegalArgumentException("orientation");
            }
        }
    }
}

