/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public abstract class OverScrollBounceEffectDecoratorBase
implements View.OnTouchListener {
    public static final float DEFAULT_TOUCH_DRAG_MOVE_RATIO_FWD = 3.0f;
    public static final float DEFAULT_TOUCH_DRAG_MOVE_RATIO_BCK = 1.0f;
    public static final float DEFAULT_DECELERATE_FACTOR = -2.0f;
    protected static final int MAX_BOUNCE_BACK_DURATION_MS = 800;
    protected static final int MIN_BOUNCE_BACK_DURATION_MS = 200;
    protected final OverScrollStartAttributes mStartAttr = new OverScrollStartAttributes();
    protected final IOverScrollDecoratorAdapter mViewAdapter;
    protected final IdleState mIdleState;
    protected final OverScrollingState mOverScrollingState;
    protected final BounceBackState mBounceBackState;
    protected IDecoratorState mCurrentState;
    protected float mVelocity;

    public OverScrollBounceEffectDecoratorBase(IOverScrollDecoratorAdapter viewAdapter, float decelerateFactor, float touchDragRatioFwd, float touchDragRatioBck) {
        this.mViewAdapter = viewAdapter;
        this.mBounceBackState = new BounceBackState(decelerateFactor);
        this.mOverScrollingState = new OverScrollingState(touchDragRatioFwd, touchDragRatioBck);
        this.mIdleState = new IdleState();
        this.mCurrentState = this.mIdleState;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                return this.mCurrentState.handleMoveTouchEvent(event);
            }
            case 1: 
            case 3: {
                return this.mCurrentState.handleUpOrCancelTouchEvent(event);
            }
        }
        return false;
    }

    protected void enterState(IDecoratorState state) {
        this.mCurrentState = state;
        this.mCurrentState.handleEntrance();
    }

    protected abstract MotionAttributes createMotionAttributes();

    protected abstract AnimationAttributes createAnimationAttributes();

    protected abstract void translateView(View var1, float var2);

    protected abstract void translateViewAndEvent(View var1, float var2, MotionEvent var3);

    protected class BounceBackState
    implements IDecoratorState,
    Animator.AnimatorListener {
        protected final Interpolator mBounceBackInterpolator = new DecelerateInterpolator();
        protected final float mDecelerateFactor;
        protected final float mDoubleDecelerateFactor;
        protected final AnimationAttributes mAnimAttributes;

        public BounceBackState(float decelerateFactor) {
            this.mDecelerateFactor = decelerateFactor;
            this.mDoubleDecelerateFactor = 2.0f * decelerateFactor;
            this.mAnimAttributes = OverScrollBounceEffectDecoratorBase.this.createAnimationAttributes();
        }

        @Override
        public void handleEntrance() {
            Animator bounceBackAnim = this.createAnimator();
            bounceBackAnim.addListener((Animator.AnimatorListener)this);
            bounceBackAnim.start();
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            return true;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            return true;
        }

        public void onAnimationEnd(Animator animation) {
            OverScrollBounceEffectDecoratorBase.this.enterState(OverScrollBounceEffectDecoratorBase.this.mIdleState);
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }

        protected Animator createAnimator() {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            this.mAnimAttributes.init(view);
            if (OverScrollBounceEffectDecoratorBase.this.mVelocity == 0.0f || OverScrollBounceEffectDecoratorBase.this.mVelocity < 0.0f && OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir || OverScrollBounceEffectDecoratorBase.this.mVelocity > 0.0f && !OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir) {
                return this.createBounceBackAnimator(this.mAnimAttributes.mAbsOffset);
            }
            float slowdownDuration = -OverScrollBounceEffectDecoratorBase.this.mVelocity / this.mDecelerateFactor;
            slowdownDuration = slowdownDuration < 0.0f ? 0.0f : slowdownDuration;
            float slowdownDistance = -OverScrollBounceEffectDecoratorBase.this.mVelocity * OverScrollBounceEffectDecoratorBase.this.mVelocity / this.mDoubleDecelerateFactor;
            float slowdownEndOffset = this.mAnimAttributes.mAbsOffset + slowdownDistance;
            ObjectAnimator slowdownAnim = ObjectAnimator.ofFloat((Object)view, this.mAnimAttributes.mProperty, (float[])new float[]{slowdownEndOffset});
            slowdownAnim.setDuration((long)((int)slowdownDuration));
            slowdownAnim.setInterpolator((TimeInterpolator)this.mBounceBackInterpolator);
            ObjectAnimator bounceBackAnim = this.createBounceBackAnimator(slowdownEndOffset);
            AnimatorSet wholeAnim = new AnimatorSet();
            wholeAnim.playSequentially(new Animator[]{slowdownAnim, bounceBackAnim});
            return wholeAnim;
        }

        private ObjectAnimator createBounceBackAnimator(float startOffset) {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            float bounceBackDuration = Math.abs(startOffset) / this.mAnimAttributes.mMaxOffset * 800.0f;
            ObjectAnimator bounceBackAnim = ObjectAnimator.ofFloat((Object)view, this.mAnimAttributes.mProperty, (float[])new float[]{OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset});
            bounceBackAnim.setDuration((long)Math.max((int)bounceBackDuration, 200));
            bounceBackAnim.setInterpolator((TimeInterpolator)this.mBounceBackInterpolator);
            return bounceBackAnim;
        }
    }

    protected class OverScrollingState
    implements IDecoratorState {
        protected final float mTouchDragRatioFwd;
        protected final float mTouchDragRatioBck;
        final MotionAttributes mMoveAttr;

        public OverScrollingState(float touchDragRatioFwd, float touchDragRatioBck) {
            this.mMoveAttr = OverScrollBounceEffectDecoratorBase.this.createMotionAttributes();
            this.mTouchDragRatioFwd = touchDragRatioFwd;
            this.mTouchDragRatioBck = touchDragRatioBck;
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            long dt;
            if (OverScrollBounceEffectDecoratorBase.this.mStartAttr.mPointerId != event.getPointerId(0)) {
                OverScrollBounceEffectDecoratorBase.this.enterState(OverScrollBounceEffectDecoratorBase.this.mBounceBackState);
                return true;
            }
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            if (!this.mMoveAttr.init(view, event)) {
                return true;
            }
            float deltaOffset = this.mMoveAttr.mDeltaOffset / (this.mMoveAttr.mDir == OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir ? this.mTouchDragRatioFwd : this.mTouchDragRatioBck);
            float newOffset = this.mMoveAttr.mAbsOffset + deltaOffset;
            if (OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir && !this.mMoveAttr.mDir && newOffset <= OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset || !OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir && this.mMoveAttr.mDir && newOffset >= OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset) {
                OverScrollBounceEffectDecoratorBase.this.translateViewAndEvent(view, OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset, event);
                OverScrollBounceEffectDecoratorBase.this.enterState(OverScrollBounceEffectDecoratorBase.this.mIdleState);
                return true;
            }
            if (view.getParent() != null) {
                view.getParent().requestDisallowInterceptTouchEvent(true);
            }
            if ((dt = event.getEventTime() - event.getHistoricalEventTime(0)) > 0L) {
                OverScrollBounceEffectDecoratorBase.this.mVelocity = deltaOffset / (float)dt;
            }
            OverScrollBounceEffectDecoratorBase.this.translateView(view, newOffset);
            return true;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            OverScrollBounceEffectDecoratorBase.this.enterState(OverScrollBounceEffectDecoratorBase.this.mBounceBackState);
            return true;
        }

        @Override
        public void handleEntrance() {
        }
    }

    protected class IdleState
    implements IDecoratorState {
        final MotionAttributes mMoveAttr;

        public IdleState() {
            this.mMoveAttr = OverScrollBounceEffectDecoratorBase.this.createMotionAttributes();
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            if (!this.mMoveAttr.init(view, event)) {
                return false;
            }
            if (OverScrollBounceEffectDecoratorBase.this.mViewAdapter.isInAbsoluteStart() && this.mMoveAttr.mDir || OverScrollBounceEffectDecoratorBase.this.mViewAdapter.isInAbsoluteEnd() && !this.mMoveAttr.mDir) {
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mPointerId = event.getPointerId(0);
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset = this.mMoveAttr.mAbsOffset;
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir = this.mMoveAttr.mDir;
                OverScrollBounceEffectDecoratorBase.this.enterState(OverScrollBounceEffectDecoratorBase.this.mOverScrollingState);
                return OverScrollBounceEffectDecoratorBase.this.mOverScrollingState.handleMoveTouchEvent(event);
            }
            return false;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            return false;
        }

        @Override
        public void handleEntrance() {
        }
    }

    protected static interface IDecoratorState {
        public boolean handleMoveTouchEvent(MotionEvent var1);

        public boolean handleUpOrCancelTouchEvent(MotionEvent var1);

        public void handleEntrance();
    }

    protected static abstract class AnimationAttributes {
        public Property<View, Float> mProperty;
        public float mAbsOffset;
        public float mMaxOffset;

        protected AnimationAttributes() {
        }

        protected abstract void init(View var1);
    }

    protected static class OverScrollStartAttributes {
        protected int mPointerId;
        protected float mAbsOffset;
        protected boolean mDir;

        protected OverScrollStartAttributes() {
        }
    }

    protected static abstract class MotionAttributes {
        public float mAbsOffset;
        public float mDeltaOffset;
        public boolean mDir;

        protected MotionAttributes() {
        }

        protected abstract boolean init(View var1, MotionEvent var2);
    }
}

