/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll.adapters;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public class RecyclerViewOverScrollDecorAdapter
implements IOverScrollDecoratorAdapter {
    protected final RecyclerView mRecyclerView;
    protected final LinearLayoutManager mLayoutManager;

    public RecyclerViewOverScrollDecorAdapter(RecyclerView recyclerView) {
        if (!(recyclerView.getLayoutManager() instanceof LinearLayoutManager)) {
            throw new IllegalArgumentException("Recycler views with non-linear layout managers are not supported by this adapter. Consider implementing a new adapter, instead");
        }
        this.mRecyclerView = recyclerView;
        this.mLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
    }

    @Override
    public View getView() {
        return this.mRecyclerView;
    }

    @Override
    public boolean isInAbsoluteStart() {
        return this.mLayoutManager.findFirstCompletelyVisibleItemPosition() == 0;
    }

    @Override
    public boolean isInAbsoluteEnd() {
        return this.mLayoutManager.findLastCompletelyVisibleItemPosition() == this.mRecyclerView.getAdapter().getItemCount() - 1;
    }
}

