/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson.compressor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DictionaryCache {
    private final int MAX_SIZE = Short.MAX_VALUE;
    private String[] data = new String[Short.MAX_VALUE];
    private short next = 0;
    private Map<String, Short> dataMap = new HashMap<String, Short>();
    private LinkedHashMap<String, Integer> slidingWindow;
    private final int windowSize;
    private int minRepetitions;
    private boolean dirty = false;
    private int dictionaryHit = 0;
    private int dictionaryMiss = 0;

    public DictionaryCache(int windowSizeArg, int minRepetitions) {
        this.windowSize = windowSizeArg;
        this.minRepetitions = minRepetitions;
        this.init();
    }

    private void init() {
        this.slidingWindow = new LinkedHashMap<String, Integer>(this.windowSize + 1, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
                return this.size() > DictionaryCache.this.windowSize;
            }
        };
    }

    public int getSize() {
        return this.next;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    protected void fromDataInputStream(DataInputStream din) throws IOException {
        this.next = (short)din.readInt();
        for (int i = 0; i < this.next; ++i) {
            String str;
            int val = 0;
            int read = din.readUnsignedByte();
            while (read == 255) {
                val += read;
                read = din.readUnsignedByte();
            }
            if ((val += read) <= 0) continue;
            byte[] raw = new byte[val];
            din.readFully(raw);
            this.data[(short)i] = str = new String(raw, StandardCharsets.UTF_8);
            this.dataMap.put(str, (short)i);
        }
    }

    protected void toDataOutputStream(DataOutputStream dout) throws IOException {
        dout.writeInt(this.next);
        for (int i = 0; i < this.next; ++i) {
            String raw = this.data[i];
            byte[] encoded = raw.getBytes(StandardCharsets.UTF_8);
            int length = encoded.length;
            while (length > 0) {
                if (length > 255) {
                    dout.writeByte(255);
                    length -= 255;
                    continue;
                }
                dout.writeByte(length);
                length = 0;
            }
            dout.write(encoded);
        }
        dout.flush();
    }

    public String get(short index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.next) {
            return null;
        }
        return this.data[index];
    }

    public short get(String value) {
        if (this.dataMap.containsKey(value)) {
            return this.dataMap.get(value);
        }
        return -1;
    }

    public short put(String value) {
        if (this.dataMap.containsKey(value)) {
            ++this.dictionaryHit;
            return this.dataMap.get(value);
        }
        if (this.next == Short.MAX_VALUE) {
            ++this.dictionaryMiss;
            return -1;
        }
        if (this.minRepetitions == 0) {
            this.data[this.next] = value;
            this.dataMap.put(value, this.next);
            this.dirty = true;
            ++this.dictionaryHit;
            short s = this.next;
            this.next = (short)(s + 1);
            return s;
        }
        if (this.slidingWindow.containsKey(value)) {
            int count = this.slidingWindow.get(value) + 1;
            if (count > this.minRepetitions) {
                this.slidingWindow.remove(value);
                this.data[this.next] = value;
                this.dataMap.put(value, this.next);
                this.dirty = true;
                ++this.dictionaryHit;
                short s = this.next;
                this.next = (short)(s + 1);
                return s;
            }
            this.slidingWindow.put(value, count);
        } else {
            this.slidingWindow.put(value, 1);
        }
        ++this.dictionaryMiss;
        return -1;
    }

    public double getDictionaryUtilization() {
        if (this.dictionaryHit + this.dictionaryMiss == 0) {
            return 0.0;
        }
        return (double)this.dictionaryHit / ((double)this.dictionaryHit + (double)this.dictionaryMiss);
    }
}

