/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson;

import me.doubledutch.lazyjson.LazyElement;
import me.doubledutch.lazyjson.LazyException;
import me.doubledutch.lazyjson.LazyNode;
import me.doubledutch.lazyjson.LazyObject;
import me.doubledutch.lazyjson.LazyParser;
import me.doubledutch.lazyjson.LazyType;

public class LazyArray
extends LazyElement {
    private LazyNode selectToken = null;
    private int selectInt = -1;

    public LazyArray(String raw) throws LazyException {
        LazyParser parser = new LazyParser(raw);
        parser.tokenize();
        if (parser.root.type != 1) {
            throw new LazyException("JSON Array must start with [", 0);
        }
        this.root = parser.root;
    }

    public LazyArray() throws LazyException {
        LazyParser parser = new LazyParser("[]");
        parser.tokenize();
        this.root = parser.root;
    }

    protected LazyArray(LazyNode root) {
        super(root);
    }

    @Override
    protected String serializeElementToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        LazyNode pointer = this.root.child;
        boolean first = true;
        while (pointer != null) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            if (pointer.type == 0) {
                buf.append(new LazyObject(pointer).toString());
            } else if (pointer.type == 1) {
                buf.append(new LazyArray(pointer).toString());
            } else if (pointer.type == 7) {
                buf.append("\"");
                buf.append(pointer.getStringValue());
                buf.append("\"");
            } else if (pointer.type == 8) {
                buf.append("\"");
                buf.append(pointer.getRawStringValue());
                buf.append("\"");
            } else if (pointer.type == 4) {
                buf.append("true");
            } else if (pointer.type == 5) {
                buf.append("false");
            } else if (pointer.type == 6) {
                buf.append("null");
            } else {
                buf.append(pointer.getStringValue());
            }
            pointer = pointer.next;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public LazyType getType() {
        return LazyType.ARRAY;
    }

    @Override
    public int hashCode() {
        int code = 2;
        block8: for (int i = 0; i < this.length(); ++i) {
            LazyType t1 = this.getType(i);
            switch (t1) {
                case STRING: {
                    code += this.getString(i).hashCode();
                    continue block8;
                }
                case INTEGER: {
                    long l = this.getLong(i);
                    code += (int)(l ^ l >>> 32);
                    continue block8;
                }
                case FLOAT: {
                    double d = this.getDouble(i);
                    long l = Double.doubleToLongBits(d);
                    code += (int)(l ^ l >>> 32);
                    continue block8;
                }
                case BOOLEAN: {
                    if (!this.getBoolean(i)) continue block8;
                    ++code;
                    continue block8;
                }
                case OBJECT: {
                    code += 37 * this.getJSONObject(i).hashCode();
                    continue block8;
                }
                case ARRAY: {
                    code += 37 * this.getJSONArray(i).hashCode();
                }
            }
        }
        return code;
    }

    public LazyType getType(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        switch (token.type) {
            case 0: {
                return LazyType.OBJECT;
            }
            case 1: {
                return LazyType.ARRAY;
            }
            case 4: {
                return LazyType.BOOLEAN;
            }
            case 5: {
                return LazyType.BOOLEAN;
            }
            case 6: {
                return LazyType.NULL;
            }
            case 7: {
                return LazyType.STRING;
            }
            case 8: {
                return LazyType.STRING;
            }
            case 9: {
                return LazyType.INTEGER;
            }
            case 10: {
                return LazyType.FLOAT;
            }
        }
        return null;
    }

    public Object get(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        if (token != null) {
            switch (token.type) {
                case 0: {
                    LazyObject obj = new LazyObject(token);
                    obj.parent = this;
                    return obj;
                }
                case 1: {
                    LazyArray arr = new LazyArray(token);
                    arr.parent = this;
                    return arr;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return LazyObject.NULL;
                }
                case 7: {
                    return token.getStringValue();
                }
                case 8: {
                    return token.getStringValue();
                }
                case 9: {
                    return token.getLongValue();
                }
                case 10: {
                    return token.getDoubleValue();
                }
            }
        }
        return null;
    }

    public Object opt(int index) throws LazyException {
        LazyNode token = this.getOptionalValueToken(index);
        if (token != null) {
            switch (token.type) {
                case 0: {
                    LazyObject obj = new LazyObject(token);
                    obj.parent = this;
                    return obj;
                }
                case 1: {
                    LazyArray arr = new LazyArray(token);
                    arr.parent = this;
                    return arr;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return LazyObject.NULL;
                }
                case 7: {
                    return token.getStringValue();
                }
                case 8: {
                    return token.getStringValue();
                }
                case 9: {
                    return token.getLongValue();
                }
                case 10: {
                    return token.getDoubleValue();
                }
            }
        }
        return null;
    }

    private void appendChild(LazyNode token) throws LazyException {
        if (this.root.child == null) {
            this.root.child = token;
            this.root.lastChild = token;
        } else {
            this.root.lastChild.next = token;
            this.root.lastChild = token;
        }
        this.root.dirty = true;
        this.selectToken = null;
        this.selectInt = -1;
    }

    private void insertChild(int index, LazyNode token) throws LazyException {
        this.root.dirty = true;
        if (index == 0) {
            token.next = this.root.child;
            this.root.child = token;
            return;
        }
        LazyNode pointer = this.root.child;
        if (pointer == null) {
            throw new LazyException("Trying to put at index " + index + " on an empty LazyArray");
        }
        for (int current = 1; current < index; ++current) {
            pointer = pointer.next;
            if (pointer != null) continue;
            throw new LazyException("Index out of bounds " + index);
        }
        token.next = pointer.next;
        pointer.next = token;
        this.selectToken = null;
        this.selectInt = -1;
    }

    public LazyArray put(String value) throws LazyException {
        LazyNode child = null;
        child = LazyArray.shouldQuoteString(value) ? this.appendAndSetDirtyString((byte)8, LazyArray.quoteString(value)) : this.appendAndSetDirtyString((byte)7, value);
        this.appendChild(child);
        return this;
    }

    public LazyArray put(int value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Integer.toString(value));
        this.appendChild(child);
        return this;
    }

    public LazyArray put(long value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Long.toString(value));
        this.appendChild(child);
        return this;
    }

    public LazyArray put(float value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Float.toString(value));
        this.appendChild(child);
        return this;
    }

    public LazyArray put(double value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Double.toString(value));
        this.appendChild(child);
        return this;
    }

    public LazyArray put(boolean value) throws LazyException {
        LazyNode child = null;
        child = value ? LazyNode.cValueTrue(-1) : LazyNode.cValueFalse(-1);
        child.dirty = true;
        this.appendChild(child);
        return this;
    }

    public LazyArray put(LazyArray value) throws LazyException {
        this.appendChild(value.root);
        return this;
    }

    public LazyArray put(LazyObject value) throws LazyException {
        this.appendChild(value.root);
        return this;
    }

    public LazyArray put(Object value) throws LazyException {
        if (value == LazyObject.NULL) {
            LazyNode child = LazyNode.cValueNull(-1);
            child.dirty = true;
            this.appendChild(child);
            return this;
        }
        if (value == null) {
            // empty if block
        }
        if (value instanceof Integer) {
            return this.put((Integer)value);
        }
        if (value instanceof Long) {
            return this.put((Long)value);
        }
        if (value instanceof Float) {
            return this.put(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.put((Double)value);
        }
        if (value instanceof Boolean) {
            return this.put((Boolean)value);
        }
        if (value instanceof String) {
            return this.put((String)value);
        }
        if (value instanceof LazyObject) {
            return this.put((LazyObject)value);
        }
        if (value instanceof LazyArray) {
            return this.put((LazyArray)value);
        }
        throw new LazyException("Unsupported object type");
    }

    public LazyArray put(int index, Object value) throws LazyException {
        if (value == LazyObject.NULL) {
            LazyNode child = LazyNode.cValueNull(-1);
            child.dirty = true;
            this.insertChild(index, child);
            return this;
        }
        if (value == null) {
            // empty if block
        }
        if (value instanceof Integer) {
            return this.put(index, (Integer)value);
        }
        if (value instanceof Long) {
            return this.put(index, (Long)value);
        }
        if (value instanceof Float) {
            return this.put(index, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.put(index, (Double)value);
        }
        if (value instanceof Boolean) {
            return this.put(index, (Boolean)value);
        }
        if (value instanceof String) {
            return this.put(index, (String)value);
        }
        if (value instanceof LazyObject) {
            return this.put(index, (LazyObject)value);
        }
        if (value instanceof LazyArray) {
            return this.put(index, (LazyArray)value);
        }
        throw new LazyException("Unsupported object type");
    }

    public LazyArray put(int index, String value) throws LazyException {
        LazyNode child = null;
        child = LazyArray.shouldQuoteString(value) ? this.appendAndSetDirtyString((byte)8, LazyArray.quoteString(value)) : this.appendAndSetDirtyString((byte)7, value);
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, int value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Integer.toString(value));
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, long value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Long.toString(value));
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, float value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Float.toString(value));
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, double value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Double.toString(value));
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, boolean value) throws LazyException {
        LazyNode child = null;
        child = value ? LazyNode.cValueTrue(-1) : LazyNode.cValueFalse(-1);
        child.dirty = true;
        this.insertChild(index, child);
        return this;
    }

    public LazyArray put(int index, LazyArray value) throws LazyException {
        this.insertChild(index, value.root);
        return this;
    }

    public LazyArray put(int index, LazyObject value) throws LazyException {
        this.insertChild(index, value.root);
        return this;
    }

    public Object remove(int index) throws LazyException {
        Object obj = this.opt(index);
        LazyNode token = this.getOptionalValueToken(index);
        if (token != null) {
            LazyNode pointer = this.root.child;
            if (pointer == token) {
                this.root.child = token.next;
            } else {
                while (pointer != null) {
                    if (pointer.next == token) {
                        pointer.next = token.next;
                    }
                    pointer = pointer.next;
                }
            }
            this.root.dirty = true;
        }
        this.selectToken = null;
        this.selectInt = -1;
        return obj;
    }

    public LazyArray getJSONArray(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        if (token.type != 1) {
            throw new LazyException("Requested value is not an array", token);
        }
        LazyArray arr = new LazyArray(token);
        arr.parent = this;
        return arr;
    }

    public LazyArray optJSONArray(int index) throws LazyException {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        if (token.type != 1) {
            return null;
        }
        LazyArray arr = new LazyArray(token);
        arr.parent = this;
        return arr;
    }

    public LazyObject getJSONObject(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        if (token.type != 0) {
            throw new LazyException("Requested value is not an object", token);
        }
        LazyObject obj = new LazyObject(token);
        obj.parent = this;
        return obj;
    }

    public LazyObject optJSONObject(int index) throws LazyException {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        if (token.type != 0) {
            return null;
        }
        LazyObject obj = new LazyObject(token);
        obj.parent = this;
        return obj;
    }

    public boolean getBoolean(int index) {
        LazyNode token = this.getValueToken(index);
        if (token.type == 4) {
            return true;
        }
        if (token.type == 5) {
            return false;
        }
        throw new LazyException("Requested value is not a boolean", token);
    }

    public boolean optBoolean(int index) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return false;
        }
        if (token.type == 6) {
            return false;
        }
        if (token.type == 4) {
            return true;
        }
        if (token.type == 5) {
            return false;
        }
        throw new LazyException("Requested value is not a boolean", token);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        if (token.type == 4) {
            return true;
        }
        if (token.type == 5) {
            return false;
        }
        throw new LazyException("Requested value is not a boolean", token);
    }

    public String getString(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        return token.getStringValue();
    }

    public String optString(int index) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        return token.getStringValue();
    }

    public String optString(int index, String defaultValue) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getStringValue();
    }

    public int getInt(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        return token.getIntValue();
    }

    public int optInt(int index) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return 0;
        }
        if (token.type == 6) {
            return 0;
        }
        return token.getIntValue();
    }

    public int optInt(int index, int defaultValue) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getIntValue();
    }

    public long getLong(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        return token.getLongValue();
    }

    public long optLong(int index) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return 0L;
        }
        if (token.type == 6) {
            return 0L;
        }
        return token.getLongValue();
    }

    public long optLong(int index, long defaultValue) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getLongValue();
    }

    public double getDouble(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        return token.getDoubleValue();
    }

    public double optDouble(int index) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return 0.0;
        }
        if (token.type == 6) {
            return 0.0;
        }
        return token.getDoubleValue();
    }

    public double optDouble(int index, double defaultValue) {
        LazyNode token = this.getOptionalValueToken(index);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getDoubleValue();
    }

    public boolean isNull(int index) throws LazyException {
        LazyNode token = this.getValueToken(index);
        return token.type == 6;
    }

    private LazyNode getValueToken(int index) throws LazyException {
        if (index < 0) {
            throw new LazyException("Array undex can not be negative");
        }
        int num = 0;
        LazyNode child = this.root.child;
        if (this.selectInt > -1 && index >= this.selectInt) {
            num = this.selectInt;
            child = this.selectToken;
        }
        while (child != null) {
            if (num == index) {
                this.selectInt = index;
                this.selectToken = child;
                return child;
            }
            ++num;
            child = child.next;
        }
        throw new LazyException("Array index out of bounds " + index);
    }

    private LazyNode getOptionalValueToken(int index) throws LazyException {
        if (index < 0) {
            throw new LazyException("Array undex can not be negative");
        }
        int num = 0;
        LazyNode child = this.root.child;
        if (this.selectInt > -1 && index >= this.selectInt) {
            num = this.selectInt;
            child = this.selectToken;
        }
        while (child != null) {
            if (num == index) {
                this.selectInt = index;
                this.selectToken = child;
                return child;
            }
            ++num;
            child = child.next;
        }
        return null;
    }
}

