/*
 * Decompiled with CFR 0.152.
 */
package me.dm7.barcodescanner.core;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import me.dm7.barcodescanner.core.DisplayUtils;
import me.dm7.barcodescanner.core.R;

public class ViewFinderView
extends View {
    private static final String TAG = "ViewFinderView";
    private Rect mFramingRect;
    private static final int MIN_FRAME_WIDTH = 240;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final float LANDSCAPE_WIDTH_RATIO = 0.625f;
    private static final float LANDSCAPE_HEIGHT_RATIO = 0.625f;
    private static final int LANDSCAPE_MAX_FRAME_WIDTH = 1200;
    private static final int LANDSCAPE_MAX_FRAME_HEIGHT = 675;
    private static final float PORTRAIT_WIDTH_RATIO = 0.875f;
    private static final float PORTRAIT_HEIGHT_RATIO = 0.375f;
    private static final int PORTRAIT_MAX_FRAME_WIDTH = 945;
    private static final int PORTRAIT_MAX_FRAME_HEIGHT = 720;
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private int scannerAlpha;
    private static final int POINT_SIZE = 10;
    private static final long ANIMATION_DELAY = 80L;

    public ViewFinderView(Context context) {
        super(context);
    }

    public ViewFinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setupViewFinder() {
        this.initFramingRect();
        this.invalidate();
    }

    public Rect getFramingRect() {
        return this.mFramingRect;
    }

    public void onDraw(Canvas canvas) {
        if (this.mFramingRect == null) {
            return;
        }
        this.drawViewFinderMask(canvas);
        this.drawViewFinderBorder(canvas);
        this.drawLaser(canvas);
    }

    public void drawViewFinderMask(Canvas canvas) {
        Paint paint = new Paint();
        Resources resources = this.getResources();
        paint.setColor(resources.getColor(R.color.viewfinder_mask));
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.mFramingRect.top, paint);
        canvas.drawRect(0.0f, (float)this.mFramingRect.top, (float)this.mFramingRect.left, (float)(this.mFramingRect.bottom + 1), paint);
        canvas.drawRect((float)(this.mFramingRect.right + 1), (float)this.mFramingRect.top, (float)width, (float)(this.mFramingRect.bottom + 1), paint);
        canvas.drawRect(0.0f, (float)(this.mFramingRect.bottom + 1), (float)width, (float)height, paint);
    }

    public void drawViewFinderBorder(Canvas canvas) {
        Paint paint = new Paint();
        Resources resources = this.getResources();
        paint.setColor(resources.getColor(R.color.viewfinder_border));
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)resources.getInteger(R.integer.viewfinder_border_width));
        int lineLength = resources.getInteger(R.integer.viewfinder_border_length);
        canvas.drawLine((float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.top - 1), (float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.top - 1 + lineLength), paint);
        canvas.drawLine((float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.top - 1), (float)(this.mFramingRect.left - 1 + lineLength), (float)(this.mFramingRect.top - 1), paint);
        canvas.drawLine((float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.bottom + 1), (float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.bottom + 1 - lineLength), paint);
        canvas.drawLine((float)(this.mFramingRect.left - 1), (float)(this.mFramingRect.bottom + 1), (float)(this.mFramingRect.left - 1 + lineLength), (float)(this.mFramingRect.bottom + 1), paint);
        canvas.drawLine((float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.top - 1), (float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.top - 1 + lineLength), paint);
        canvas.drawLine((float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.top - 1), (float)(this.mFramingRect.right + 1 - lineLength), (float)(this.mFramingRect.top - 1), paint);
        canvas.drawLine((float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.bottom + 1), (float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.bottom + 1 - lineLength), paint);
        canvas.drawLine((float)(this.mFramingRect.right + 1), (float)(this.mFramingRect.bottom + 1), (float)(this.mFramingRect.right + 1 - lineLength), (float)(this.mFramingRect.bottom + 1), paint);
    }

    public void drawLaser(Canvas canvas) {
        Paint paint = new Paint();
        Resources resources = this.getResources();
        paint.setColor(resources.getColor(R.color.viewfinder_laser));
        paint.setAlpha(SCANNER_ALPHA[this.scannerAlpha]);
        paint.setStyle(Paint.Style.FILL);
        this.scannerAlpha = (this.scannerAlpha + 1) % SCANNER_ALPHA.length;
        int middle = this.mFramingRect.height() / 2 + this.mFramingRect.top;
        canvas.drawRect((float)(this.mFramingRect.left + 2), (float)(middle - 1), (float)(this.mFramingRect.right - 1), (float)(middle + 2), paint);
        this.postInvalidateDelayed(80L, this.mFramingRect.left - 10, this.mFramingRect.top - 10, this.mFramingRect.right + 10, this.mFramingRect.bottom + 10);
    }

    public synchronized void initFramingRect() {
        int height;
        int width;
        Point screenResolution = DisplayUtils.getScreenResolution(this.getContext());
        if (screenResolution == null) {
            return;
        }
        int orientation = DisplayUtils.getScreenOrientation(this.getContext());
        if (orientation != 1) {
            width = ViewFinderView.findDesiredDimensionInRange(0.625f, screenResolution.x, 240, 1200);
            height = ViewFinderView.findDesiredDimensionInRange(0.625f, screenResolution.y, 240, 675);
        } else {
            width = ViewFinderView.findDesiredDimensionInRange(0.875f, screenResolution.x, 240, 945);
            height = ViewFinderView.findDesiredDimensionInRange(0.375f, screenResolution.y, 240, 720);
        }
        int leftOffset = (screenResolution.x - width) / 2;
        int topOffset = (screenResolution.y - height) / 2;
        this.mFramingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
    }

    private static int findDesiredDimensionInRange(float ratio, int resolution, int hardMin, int hardMax) {
        int dim = (int)(ratio * (float)resolution);
        if (dim < hardMin) {
            return hardMin;
        }
        if (dim > hardMax) {
            return hardMax;
        }
        return dim;
    }
}

