/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.support.annotation.NonNull;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.AbsListView;
import android.widget.HorizontalScrollView;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import me.dkzwm.widget.srl.ILifecycleObserver;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.indicator.IIndicator;
import me.dkzwm.widget.srl.utils.SRLog;

public class QuickConfigAutoRefreshUtil
implements ILifecycleObserver,
SmoothRefreshLayout.OnNestedScrollChangedListener,
SmoothRefreshLayout.OnUIPositionChangedListener {
    private SmoothRefreshLayout mRefreshLayout;
    private View mTargetView;
    private int mStatus;
    private boolean mNeedToTriggerRefresh = false;
    private boolean mNeedToTriggerLoadMore = false;
    private boolean mCachedActionAtOnce = false;
    private boolean mCachedAutoRefreshUseSmoothScroll = false;
    private ObjectAnimator mAnimator;

    public QuickConfigAutoRefreshUtil(@NonNull View targetScrollableView) {
        this.mTargetView = targetScrollableView;
    }

    public void onAttached(SmoothRefreshLayout layout) {
        this.mRefreshLayout = layout;
        this.mRefreshLayout.addOnUIPositionChangedListener((SmoothRefreshLayout.OnUIPositionChangedListener)this);
        this.mRefreshLayout.addOnNestedScrollChangedListener((SmoothRefreshLayout.OnNestedScrollChangedListener)this);
    }

    public void onDetached(SmoothRefreshLayout layout) {
        this.mRefreshLayout.removeOnUIPositionChangedListener((SmoothRefreshLayout.OnUIPositionChangedListener)this);
        this.mRefreshLayout.removeOnNestedScrollChangedListener((SmoothRefreshLayout.OnNestedScrollChangedListener)this);
        this.mRefreshLayout = null;
    }

    public void autoRefresh(boolean scrollToEdgeUseSmoothScroll, boolean atOnce, boolean autoRefreshUseSmoothScroll) {
        if (this.mRefreshLayout != null) {
            if (this.mStatus != 1) {
                return;
            }
            if (this.mRefreshLayout.isNotYetInEdgeCannotMoveHeader()) {
                if (this.mRefreshLayout.getSupportScrollAxis() == 2) {
                    this.verticalScrollToEdge(true, scrollToEdgeUseSmoothScroll);
                } else if (this.mRefreshLayout.getSupportScrollAxis() == 1) {
                    this.horizontalScrollToEdge(true, scrollToEdgeUseSmoothScroll);
                }
                this.mNeedToTriggerRefresh = true;
                this.mCachedActionAtOnce = atOnce;
                this.mCachedAutoRefreshUseSmoothScroll = autoRefreshUseSmoothScroll;
            } else {
                this.mRefreshLayout.autoRefresh(atOnce, autoRefreshUseSmoothScroll);
                this.mNeedToTriggerRefresh = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            }
        }
    }

    public void autoLoadMore(boolean scrollToEdgeUseSmoothScroll, boolean atOnce, boolean autoRefreshUseSmoothScroll) {
        if (this.mRefreshLayout != null) {
            if (this.mStatus != 1) {
                return;
            }
            if (this.mRefreshLayout.isNotYetInEdgeCannotMoveFooter()) {
                if (this.mRefreshLayout.getSupportScrollAxis() == 2) {
                    this.verticalScrollToEdge(false, scrollToEdgeUseSmoothScroll);
                } else if (this.mRefreshLayout.getSupportScrollAxis() == 1) {
                    this.horizontalScrollToEdge(false, scrollToEdgeUseSmoothScroll);
                }
                this.mNeedToTriggerLoadMore = true;
                this.mCachedActionAtOnce = atOnce;
                this.mCachedAutoRefreshUseSmoothScroll = autoRefreshUseSmoothScroll;
            } else {
                this.mRefreshLayout.autoLoadMore(atOnce, autoRefreshUseSmoothScroll);
                this.mNeedToTriggerLoadMore = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            }
        }
    }

    private void verticalScrollToEdge(boolean toTop, boolean useSmoothScroll) {
        if (this.mTargetView instanceof ScrollView) {
            ScrollView scrollView = (ScrollView)this.mTargetView;
            if (scrollView.getChildCount() > 0) {
                if (useSmoothScroll) {
                    scrollView.smoothScrollTo(0, toTop ? 0 : scrollView.getHeight());
                } else {
                    scrollView.scrollTo(0, toTop ? 0 : scrollView.getHeight());
                }
            }
        } else if (this.mTargetView instanceof AbsListView) {
            AbsListView absListView = (AbsListView)this.mTargetView;
            if (absListView.getChildCount() > 0) {
                if (useSmoothScroll) {
                    absListView.smoothScrollToPosition(toTop ? 0 : ((ListAdapter)absListView.getAdapter()).getCount() - 1);
                } else {
                    absListView.setSelection(toTop ? 0 : ((ListAdapter)absListView.getAdapter()).getCount() - 1);
                }
            }
        } else if (this.mTargetView instanceof NestedScrollView) {
            NestedScrollView scrollView = (NestedScrollView)this.mTargetView;
            if (useSmoothScroll) {
                scrollView.smoothScrollTo(0, toTop ? 0 : scrollView.getHeight());
            } else {
                scrollView.scrollTo(0, toTop ? 0 : scrollView.getHeight());
            }
        } else {
            try {
                if (this.mTargetView instanceof RecyclerView) {
                    RecyclerView recyclerView = (RecyclerView)this.mTargetView;
                    if (recyclerView.getChildCount() > 0) {
                        if (useSmoothScroll) {
                            recyclerView.smoothScrollToPosition(toTop ? 0 : recyclerView.getAdapter().getItemCount() - 1);
                        } else {
                            recyclerView.scrollToPosition(toTop ? 0 : recyclerView.getAdapter().getItemCount() - 1);
                        }
                    }
                    return;
                }
            }
            catch (NoClassDefFoundError recyclerView) {
                // empty catch block
            }
            if (useSmoothScroll) {
                this.cancelAnimator();
                float distance = toTop ? (float)this.mTargetView.getScrollY() : (float)(this.mTargetView.getHeight() - this.mTargetView.getScrollY());
                this.mAnimator = ObjectAnimator.ofInt((Object)this.mTargetView, (String)"scrollY", (int[])new int[]{this.mTargetView.getScrollY(), toTop ? 0 : this.mTargetView.getHeight()});
                DisplayMetrics dm = this.mTargetView.getResources().getDisplayMetrics();
                this.mAnimator.setDuration((long)(distance / (float)dm.heightPixels * 200.0f));
                this.mAnimator.start();
                this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerRefresh = false;
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerLoadMore = false;
                    }

                    public void onAnimationCancel(Animator animation) {
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerRefresh = false;
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerLoadMore = false;
                    }
                });
                SRLog.d((String)this.getClass().getSimpleName(), (String)"In some special cases the animation should be interrupted but not actually interrupted, so you should call `cancelAnimator` method when user finger touched views");
            } else {
                this.cancelAnimator();
                this.mTargetView.scrollTo(this.mTargetView.getScrollX(), toTop ? 0 : this.mTargetView.getHeight());
            }
        }
    }

    private void horizontalScrollToEdge(boolean toLeft, boolean useSmoothScroll) {
        if (this.mTargetView instanceof HorizontalScrollView) {
            HorizontalScrollView scrollView = (HorizontalScrollView)this.mTargetView;
            if (useSmoothScroll) {
                scrollView.smoothScrollTo(toLeft ? 0 : scrollView.getWidth(), 0);
            } else {
                scrollView.scrollTo(toLeft ? 0 : scrollView.getWidth(), 0);
            }
        } else {
            try {
                if (this.mTargetView instanceof RecyclerView) {
                    RecyclerView recyclerView = (RecyclerView)this.mTargetView;
                    if (recyclerView.getChildCount() > 0) {
                        if (useSmoothScroll) {
                            recyclerView.smoothScrollToPosition(toLeft ? 0 : recyclerView.getAdapter().getItemCount() - 1);
                        } else {
                            recyclerView.scrollToPosition(toLeft ? 0 : recyclerView.getAdapter().getItemCount() - 1);
                        }
                    }
                    return;
                }
            }
            catch (NoClassDefFoundError recyclerView) {
                // empty catch block
            }
            if (useSmoothScroll) {
                this.cancelAnimator();
                float distance = toLeft ? (float)this.mTargetView.getScrollX() : (float)(this.mTargetView.getWidth() - this.mTargetView.getScrollX());
                this.mAnimator = ObjectAnimator.ofInt((Object)this.mTargetView, (String)"scrollX", (int[])new int[]{this.mTargetView.getScrollX(), toLeft ? 0 : this.mTargetView.getWidth()});
                DisplayMetrics dm = this.mTargetView.getResources().getDisplayMetrics();
                this.mAnimator.setDuration((long)(distance / (float)dm.widthPixels * 200.0f));
                this.mAnimator.start();
                this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerRefresh = false;
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerLoadMore = false;
                    }

                    public void onAnimationCancel(Animator animation) {
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerRefresh = false;
                        QuickConfigAutoRefreshUtil.this.mNeedToTriggerLoadMore = false;
                    }
                });
                SRLog.d((String)this.getClass().getSimpleName(), (String)"In some special cases the animation should be interrupted but not actually interrupted, so you should call `cancelAnimator` method when user finger touched views");
            } else {
                this.cancelAnimator();
                this.mTargetView.scrollTo(toLeft ? 0 : this.mTargetView.getHeight(), this.mTargetView.getScrollY());
            }
        }
    }

    public void cancelAnimator() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    public void onChanged(byte status, IIndicator indicator) {
        this.mStatus = status;
    }

    public void onNestedScrollChanged() {
        if (this.mRefreshLayout != null) {
            if (this.mNeedToTriggerRefresh && !this.mRefreshLayout.isNotYetInEdgeCannotMoveHeader()) {
                this.mRefreshLayout.autoRefresh(this.mCachedActionAtOnce, this.mCachedAutoRefreshUseSmoothScroll);
                this.mNeedToTriggerRefresh = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            } else if (this.mNeedToTriggerLoadMore && !this.mRefreshLayout.isNotYetInEdgeCannotMoveFooter()) {
                this.mRefreshLayout.autoLoadMore(this.mCachedActionAtOnce, this.mCachedAutoRefreshUseSmoothScroll);
                this.mNeedToTriggerLoadMore = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            }
        }
    }
}

