/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.extra.footer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.StringRes;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.ext.classic.R;
import me.dkzwm.widget.srl.extra.AbsClassicRefreshView;
import me.dkzwm.widget.srl.extra.ClassicConfig;
import me.dkzwm.widget.srl.indicator.IIndicator;

public class ClassicFooter<T extends IIndicator>
extends AbsClassicRefreshView<T> {
    private boolean mNoMoreDataChangedView = false;
    @StringRes
    private int mPullUpToLoadRes = R.string.sr_pull_up_to_load;
    @StringRes
    private int mPullUpRes = R.string.sr_pull_up;
    @StringRes
    private int mLoadingRes = R.string.sr_loading;
    @StringRes
    private int mLoadSuccessfulRes = R.string.sr_load_complete;
    @StringRes
    private int mLoadFailRes = R.string.sr_load_failed;
    @StringRes
    private int mReleaseToLoadRes = R.string.sr_release_to_load;
    @StringRes
    private int mNoMoreDataRes = R.string.sr_no_more_data;
    private View.OnClickListener mNoMoreDataClickListener;

    public ClassicFooter(Context context) {
        this(context, null);
    }

    public ClassicFooter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClassicFooter(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.sr_classic_arrow_icon);
        Matrix matrix = new Matrix();
        matrix.postRotate(180.0f);
        Bitmap dstBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (!bitmap.isRecycled()) {
            bitmap.recycle();
        }
        this.mArrowImageView.setImageBitmap(dstBitmap);
    }

    public void setPullUpToLoadRes(@StringRes int pullUpToLoadRes) {
        this.mPullUpToLoadRes = pullUpToLoadRes;
    }

    public void setPullUpRes(@StringRes int pullUpRes) {
        this.mPullUpRes = pullUpRes;
    }

    public void setLoadingRes(@StringRes int loadingRes) {
        this.mLoadingRes = loadingRes;
    }

    public void setLoadSuccessfulRes(@StringRes int loadSuccessfulRes) {
        this.mLoadSuccessfulRes = loadSuccessfulRes;
    }

    public void setLoadFailRes(@StringRes int loadFailRes) {
        this.mLoadFailRes = loadFailRes;
    }

    public void setReleaseToLoadRes(@StringRes int releaseToLoadRes) {
        this.mReleaseToLoadRes = releaseToLoadRes;
    }

    public void setNoMoreDataRes(int noMoreDataRes) {
        this.mNoMoreDataRes = noMoreDataRes;
    }

    public void setNoMoreDataClickListener(View.OnClickListener onClickListener) {
        this.mNoMoreDataClickListener = onClickListener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        Log.d((String)this.getClass().getSimpleName(), (String)"---------5:");
    }

    public int getType() {
        return 1;
    }

    @Override
    public void onReset(SmoothRefreshLayout frame) {
        super.onReset(frame);
        this.mNoMoreDataChangedView = false;
        this.mTitleTextView.setOnClickListener(null);
    }

    public void onRefreshPrepare(SmoothRefreshLayout frame) {
        this.mArrowImageView.clearAnimation();
        this.mShouldShowLastUpdate = true;
        this.mNoMoreDataChangedView = false;
        this.tryUpdateLastUpdateTime();
        if (!TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey)) {
            this.mLastUpdateTimeUpdater.start();
        }
        this.mProgressBar.setVisibility(4);
        this.mArrowImageView.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        this.mTitleTextView.setOnClickListener(null);
        if (frame.isEnabledPullToRefresh() && !frame.isDisabledPerformLoadMore()) {
            this.mTitleTextView.setText(this.mPullUpToLoadRes);
        } else {
            this.mTitleTextView.setText(this.mPullUpRes);
        }
        this.requestLayout();
    }

    public void onRefreshBegin(SmoothRefreshLayout frame, T indicator) {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(4);
        this.mProgressBar.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        this.mTitleTextView.setText(this.mLoadingRes);
        this.tryUpdateLastUpdateTime();
    }

    public void onRefreshComplete(SmoothRefreshLayout frame, boolean isSuccessful) {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(4);
        this.mProgressBar.setVisibility(4);
        this.mTitleTextView.setVisibility(0);
        boolean noMoreData = frame.isEnabledNoMoreData();
        if (frame.isRefreshSuccessful()) {
            this.mTitleTextView.setText(noMoreData ? this.mNoMoreDataRes : this.mLoadSuccessfulRes);
            this.mLastUpdateTime = System.currentTimeMillis();
            ClassicConfig.updateTime(this.getContext(), this.mLastUpdateTimeKey, this.mLastUpdateTime);
        } else {
            this.mTitleTextView.setText(noMoreData ? this.mNoMoreDataRes : this.mLoadFailRes);
        }
        this.mLastUpdateTimeUpdater.stop();
        this.mLastUpdateTextView.setVisibility(8);
        if (noMoreData) {
            this.mTitleTextView.setOnClickListener(this.mNoMoreDataClickListener);
        }
    }

    public void onRefreshPositionChanged(SmoothRefreshLayout frame, byte status, T indicator) {
        int offsetToLoadMore = indicator.getOffsetToLoadMore();
        int currentPos = indicator.getCurrentPos();
        int lastPos = indicator.getLastPos();
        if (frame.isEnabledNoMoreData()) {
            if (currentPos > lastPos && !this.mNoMoreDataChangedView) {
                this.mTitleTextView.setVisibility(0);
                this.mLastUpdateTextView.setVisibility(8);
                this.mProgressBar.setVisibility(4);
                this.mLastUpdateTimeUpdater.stop();
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.setVisibility(8);
                this.mTitleTextView.setText(this.mNoMoreDataRes);
                this.mTitleTextView.setOnClickListener(this.mNoMoreDataClickListener);
                this.mNoMoreDataChangedView = true;
            }
            return;
        }
        this.mNoMoreDataChangedView = false;
        if (currentPos < offsetToLoadMore && lastPos >= offsetToLoadMore) {
            if (indicator.hasTouched() && status == 2) {
                this.mTitleTextView.setVisibility(0);
                if (frame.isEnabledPullToRefresh() && !frame.isDisabledPerformLoadMore()) {
                    this.mTitleTextView.setText(this.mPullUpToLoadRes);
                } else {
                    this.mTitleTextView.setText(this.mPullUpRes);
                }
                this.mArrowImageView.setVisibility(0);
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.startAnimation((Animation)this.mReverseFlipAnimation);
            }
        } else if (currentPos > offsetToLoadMore && lastPos <= offsetToLoadMore && indicator.hasTouched() && status == 2) {
            this.mTitleTextView.setVisibility(0);
            if (!frame.isEnabledPullToRefresh() && !frame.isDisabledPerformLoadMore()) {
                this.mTitleTextView.setText(this.mReleaseToLoadRes);
            }
            this.mArrowImageView.setVisibility(0);
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.startAnimation((Animation)this.mFlipAnimation);
        }
    }
}

