/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.extra;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.ext.classic.R;
import me.dkzwm.widget.srl.extra.ClassicConfig;
import me.dkzwm.widget.srl.extra.IRefreshView;
import me.dkzwm.widget.srl.extra.LastUpdateTimeUpdater;
import me.dkzwm.widget.srl.indicator.IIndicator;
import me.dkzwm.widget.srl.util.PixelUtl;

public abstract class AbsClassicRefreshView<T extends IIndicator>
extends RelativeLayout
implements IRefreshView<T>,
LastUpdateTimeUpdater.ITimeUpdater {
    private static final Interpolator sLinearInterpolator = new LinearInterpolator();
    protected int mStyle = 0;
    protected int mDefaultHeightInDP = 64;
    protected RotateAnimation mFlipAnimation;
    protected RotateAnimation mReverseFlipAnimation;
    protected TextView mTitleTextView;
    protected TextView mLastUpdateTextView;
    protected ImageView mArrowImageView;
    protected ProgressBar mProgressBar;
    protected String mLastUpdateTimeKey;
    protected boolean mShouldShowLastUpdate;
    protected long mLastUpdateTime = -1L;
    protected int mRotateAniTime = 200;
    protected LastUpdateTimeUpdater mLastUpdateTimeUpdater;

    public AbsClassicRefreshView(Context context) {
        this(context, null);
    }

    public AbsClassicRefreshView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AbsClassicRefreshView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            int style;
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.AbsClassicRefreshView, 0, 0);
            this.mStyle = style = arr.getInt(R.styleable.AbsClassicRefreshView_sr_style, this.mStyle);
            arr.recycle();
        }
        this.mFlipAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mFlipAnimation.setInterpolator(sLinearInterpolator);
        this.mFlipAnimation.setDuration((long)this.mRotateAniTime);
        this.mFlipAnimation.setFillAfter(true);
        this.mReverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mReverseFlipAnimation.setInterpolator(sLinearInterpolator);
        this.mReverseFlipAnimation.setDuration((long)this.mRotateAniTime);
        this.mReverseFlipAnimation.setFillAfter(true);
        ClassicConfig.createClassicViews(this);
        this.mArrowImageView = (ImageView)this.findViewById(R.id.sr_classic_arrow);
        this.mTitleTextView = (TextView)this.findViewById(R.id.sr_classic_title);
        this.mLastUpdateTextView = (TextView)this.findViewById(R.id.sr_classic_last_update);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.sr_classic_progress);
        this.mLastUpdateTimeUpdater = new LastUpdateTimeUpdater(this);
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(0);
        this.mProgressBar.setVisibility(4);
    }

    public void tryUpdateLastUpdateTime() {
        if (this.canUpdate()) {
            this.updateTime(this);
        }
    }

    public TextView getLastUpdateTextView() {
        return this.mLastUpdateTextView;
    }

    @Override
    public void updateTime(AbsClassicRefreshView refreshView) {
        String time = ClassicConfig.getLastUpdateTime(this.getContext(), this.mLastUpdateTime, this.mLastUpdateTimeKey);
        if (TextUtils.isEmpty((CharSequence)time)) {
            this.mLastUpdateTextView.setVisibility(8);
        } else {
            this.mLastUpdateTextView.setVisibility(0);
            this.mLastUpdateTextView.setText((CharSequence)time);
        }
    }

    @Override
    public boolean canUpdate() {
        return !TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey) && this.mShouldShowLastUpdate;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mLastUpdateTimeUpdater.stop();
        this.mFlipAnimation.cancel();
        this.mReverseFlipAnimation.cancel();
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int style) {
        this.mStyle = style;
        this.requestLayout();
    }

    public void setTimeUpdater(@NonNull LastUpdateTimeUpdater.ITimeUpdater timeUpdater) {
        this.mLastUpdateTimeUpdater.setTimeUpdater(timeUpdater);
    }

    public void setDefaultHeightInDP(@IntRange(from=0L) int defaultHeightInDP) {
        this.mDefaultHeightInDP = defaultHeightInDP;
    }

    public int getCustomHeight() {
        return PixelUtl.dp2px((Context)this.getContext(), (float)this.mDefaultHeightInDP);
    }

    @NonNull
    public View getView() {
        return this;
    }

    public void onReset(SmoothRefreshLayout frame) {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(0);
        this.mProgressBar.setVisibility(4);
        this.mShouldShowLastUpdate = true;
        this.mLastUpdateTimeUpdater.stop();
        this.tryUpdateLastUpdateTime();
    }

    public void onFingerUp(SmoothRefreshLayout layout, T indicator) {
    }

    public void onPureScrollPositionChanged(SmoothRefreshLayout layout, byte status, T indicator) {
        if (indicator.hasJustLeftStartPosition()) {
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.setVisibility(4);
            this.mProgressBar.setVisibility(4);
            this.mTitleTextView.setVisibility(8);
            this.mArrowImageView.setVisibility(8);
            this.mLastUpdateTextView.setVisibility(8);
            this.mShouldShowLastUpdate = false;
            this.mLastUpdateTimeUpdater.stop();
            this.tryUpdateLastUpdateTime();
        }
    }

    public void setRotateAniTime(int time) {
        if (time == this.mRotateAniTime || time <= 0) {
            return;
        }
        this.mRotateAniTime = time;
        this.mFlipAnimation.setDuration((long)this.mRotateAniTime);
        this.mReverseFlipAnimation.setDuration((long)this.mRotateAniTime);
    }

    public void setLastUpdateTimeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mLastUpdateTimeKey = key;
    }

    public void setTitleTextColor(@ColorInt int color) {
        this.mTitleTextView.setTextColor(color);
    }

    public void setLastUpdateTextColor(@ColorInt int color) {
        this.mLastUpdateTextView.setTextColor(color);
    }
}

