/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Objects;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.UploadIdFactory;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadLock;
import me.desair.tus.server.upload.UploadLockingService;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.concatenation.UploadConcatenationService;

public class ThreadLocalCachedStorageAndLockingService
implements UploadLockingService,
UploadStorageService {
    private final ThreadLocal<WeakReference<UploadInfo>> uploadInfoCache = new ThreadLocal();
    private final UploadLockingService lockingServiceDelegate;
    private final UploadStorageService storageServiceDelegate;
    private UploadIdFactory idFactory;

    public ThreadLocalCachedStorageAndLockingService(UploadStorageService storageServiceDelegate, UploadLockingService lockingServiceDelegate) {
        this.storageServiceDelegate = storageServiceDelegate.getClass() == ThreadLocalCachedStorageAndLockingService.class ? ((ThreadLocalCachedStorageAndLockingService)storageServiceDelegate).storageServiceDelegate : storageServiceDelegate;
        this.lockingServiceDelegate = lockingServiceDelegate.getClass() == ThreadLocalCachedStorageAndLockingService.class ? ((ThreadLocalCachedStorageAndLockingService)lockingServiceDelegate).lockingServiceDelegate : lockingServiceDelegate;
    }

    @Override
    public UploadInfo getUploadInfo(UploadId id) throws IOException {
        UploadInfo uploadInfo;
        WeakReference<UploadInfo> ref = this.uploadInfoCache.get();
        if (ref == null || (uploadInfo = (UploadInfo)ref.get()) == null || !id.equals(uploadInfo.getId())) {
            uploadInfo = this.storageServiceDelegate.getUploadInfo(id);
            this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        }
        return uploadInfo;
    }

    @Override
    public UploadInfo getUploadInfo(String uploadUrl, String ownerKey) throws IOException {
        UploadInfo uploadInfo = this.getUploadInfo(this.idFactory.readUploadId(uploadUrl));
        if (uploadInfo == null || !Objects.equals(uploadInfo.getOwnerKey(), ownerKey)) {
            uploadInfo = this.storageServiceDelegate.getUploadInfo(uploadUrl, ownerKey);
            this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        }
        return uploadInfo;
    }

    @Override
    public void update(UploadInfo uploadInfo) throws IOException, UploadNotFoundException {
        this.storageServiceDelegate.update(uploadInfo);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        this.idFactory = idFactory;
        this.storageServiceDelegate.setIdFactory(idFactory);
        this.lockingServiceDelegate.setIdFactory(idFactory);
    }

    @Override
    public String getUploadUri() {
        return this.storageServiceDelegate.getUploadUri();
    }

    @Override
    public UploadInfo append(UploadInfo upload, InputStream inputStream) throws IOException, TusException {
        UploadInfo info = this.storageServiceDelegate.append(upload, inputStream);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(info));
        return info;
    }

    @Override
    public void setMaxUploadSize(Long maxUploadSize) {
        this.storageServiceDelegate.setMaxUploadSize(maxUploadSize);
    }

    @Override
    public long getMaxUploadSize() {
        return this.storageServiceDelegate.getMaxUploadSize();
    }

    @Override
    public UploadInfo create(UploadInfo info, String ownerKey) throws IOException {
        UploadInfo uploadInfo = this.storageServiceDelegate.create(info, ownerKey);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        return uploadInfo;
    }

    @Override
    public InputStream getUploadedBytes(String uploadUri, String ownerKey) throws IOException, UploadNotFoundException {
        return this.storageServiceDelegate.getUploadedBytes(uploadUri, ownerKey);
    }

    @Override
    public InputStream getUploadedBytes(UploadId id) throws IOException, UploadNotFoundException {
        return this.storageServiceDelegate.getUploadedBytes(id);
    }

    @Override
    public void copyUploadTo(UploadInfo info, OutputStream outputStream) throws UploadNotFoundException, IOException {
        this.storageServiceDelegate.copyUploadTo(info, outputStream);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(info));
    }

    @Override
    public void cleanupExpiredUploads(UploadLockingService uploadLockingService) throws IOException {
        this.storageServiceDelegate.cleanupExpiredUploads(uploadLockingService);
        this.cleanupCache();
    }

    @Override
    public void removeLastNumberOfBytes(UploadInfo uploadInfo, long byteCount) throws UploadNotFoundException, IOException {
        this.storageServiceDelegate.removeLastNumberOfBytes(uploadInfo, byteCount);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
    }

    @Override
    public void terminateUpload(UploadInfo uploadInfo) throws UploadNotFoundException, IOException {
        this.storageServiceDelegate.terminateUpload(uploadInfo);
        this.cleanupCache();
    }

    @Override
    public Long getUploadExpirationPeriod() {
        return this.storageServiceDelegate.getUploadExpirationPeriod();
    }

    @Override
    public void setUploadExpirationPeriod(Long uploadExpirationPeriod) {
        this.storageServiceDelegate.setUploadExpirationPeriod(uploadExpirationPeriod);
    }

    @Override
    public void setUploadConcatenationService(UploadConcatenationService concatenationService) {
        this.storageServiceDelegate.setUploadConcatenationService(concatenationService);
    }

    @Override
    public UploadConcatenationService getUploadConcatenationService() {
        return this.storageServiceDelegate.getUploadConcatenationService();
    }

    @Override
    public UploadLock lockUploadByUri(String requestUri) throws TusException, IOException {
        UploadLock uploadLock = this.lockingServiceDelegate.lockUploadByUri(requestUri);
        return new CachedLock(uploadLock);
    }

    @Override
    public void cleanupStaleLocks() throws IOException {
        this.lockingServiceDelegate.cleanupStaleLocks();
        this.cleanupCache();
    }

    @Override
    public boolean isLocked(UploadId id) {
        return this.lockingServiceDelegate.isLocked(id);
    }

    private void cleanupCache() {
        WeakReference<UploadInfo> ref = this.uploadInfoCache.get();
        if (ref != null) {
            this.uploadInfoCache.remove();
            ref.clear();
        }
    }

    class CachedLock
    implements UploadLock {
        private final UploadLock delegate;

        CachedLock(UploadLock delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getUploadUri() {
            return this.delegate != null ? this.delegate.getUploadUri() : null;
        }

        @Override
        public void release() {
            if (this.delegate != null) {
                this.delegate.release();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
            ThreadLocalCachedStorageAndLockingService.this.cleanupCache();
        }
    }
}

