/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.download;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadInProgressException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;

public class DownloadGetRequestHandler
extends AbstractRequestHandler {
    private static final String CONTENT_DISPOSITION_FORMAT = "attachment; filename=\"%s\"; filename*=UTF-8''%s";

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.GET.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        UploadInfo info = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (info == null || info.isUploadInProgress()) {
            throw new UploadInProgressException("Upload " + servletRequest.getRequestURI() + " is still in progress and cannot be downloaded yet");
        }
        servletResponse.setHeader("Content-Length", Objects.toString(info.getLength()));
        servletResponse.setHeader("Content-Disposition", String.format(CONTENT_DISPOSITION_FORMAT, info.getFileName(), URLEncoder.encode(info.getFileName(), StandardCharsets.UTF_8.toString()).replace("+", "%20")));
        servletResponse.setHeader("Content-Type", info.getFileMimeType());
        if (info.hasMetadata()) {
            servletResponse.setHeader("Upload-Metadata", info.getEncodedMetadata());
        }
        uploadStorageService.copyUploadTo(info, (OutputStream)servletResponse.getOutputStream());
        servletResponse.setStatus(200);
    }
}

