/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.creation.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.PostOnInvalidRequestURIException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;

public class PostUriValidator
implements RequestValidator {
    private Pattern uploadUriPattern = null;

    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        Matcher uploadUriMatcher = this.getUploadUriPattern(uploadStorageService).matcher(request.getRequestURI());
        if (!uploadUriMatcher.matches()) {
            throw new PostOnInvalidRequestURIException("POST requests have to be sent to '" + uploadStorageService.getUploadUri() + "'. ");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    private Pattern getUploadUriPattern(UploadStorageService uploadStorageService) {
        if (this.uploadUriPattern == null) {
            this.uploadUriPattern = Pattern.compile("^" + uploadStorageService.getUploadUri() + "$");
        }
        return this.uploadUriPattern;
    }
}

