/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.concatenation.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.PatchOnFinalUploadNotAllowedException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.UploadType;

public class PatchFinalUploadValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(request.getRequestURI(), ownerKey);
        if (uploadInfo != null && UploadType.CONCATENATED.equals((Object)uploadInfo.getUploadType())) {
            throw new PatchOnFinalUploadNotAllowedException("You cannot send a PATCH request for a concatenated upload URI");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

