/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.core.validation;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.exception.UploadOffsetMismatchException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class UploadOffsetValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String expectedOffset;
        String uploadOffset = Utils.getHeader(request, "Upload-Offset");
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(request.getRequestURI(), ownerKey);
        if (uploadInfo != null && !StringUtils.equals((CharSequence)(expectedOffset = Objects.toString(uploadInfo.getOffset())), (CharSequence)uploadOffset)) {
            throw new UploadOffsetMismatchException("The Upload-Offset was " + StringUtils.trimToNull((String)uploadOffset) + " but expected " + expectedOffset);
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

