/*
 * Decompiled with CFR 0.152.
 */
package me.decimo.app.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.media.SoundPool;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import me.decimo.app.widget.AnimateDrawable;
import me.decimo.app.widget.R;

public class WheelView
extends View
implements View.OnTouchListener {
    private Context context;
    private int attrDrawableWheel;
    private int attrDrawablePointer;
    private boolean attrIsClockwise = true;
    private int attrRotateDegree = 45;
    private float attrScalePointer = 0.5f;
    private int attrDelayEndTime = 0;
    private Bitmap wheelBitmap;
    private Bitmap pointerBitmap;
    private int pointerX = 0;
    private int pointerY = 0;
    private AnimateDrawable mWheelDrawable;
    private Drawable wheelMovingDot;
    private rotateAnimation anWheel;
    private int spin_round = 6;
    private int duration = 4700;
    private AnimateDrawable mPointerDrawable;
    private Drawable pointerMovingDot;
    private rotateAnimation anPointer;
    private SoundPool soundEffect = new SoundPool(1, 3, 0);
    int soundId;
    int streamId;
    private OnSpinListener spinListener;
    private OnTouchSpinListener touchSpinListener;
    private boolean isSpining = false;
    private final String TAG = "WHEELVIEW";
    private Handler handler;

    public WheelView(Context context) {
        super(context);
        this.context = context;
        this.soundId = this.soundEffect.load(context, R.raw.wheel_spin, 1);
        this.setOnTouchListener(this);
        this.handler = new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.WheelView, 0, 0);
        try {
            this.attrDrawableWheel = a.getResourceId(R.styleable.WheelView_drawableWheel, R.drawable.default_wheel);
            this.attrDrawablePointer = a.getResourceId(R.styleable.WheelView_drawablePointer, R.drawable.default_pointer);
            this.attrIsClockwise = a.getBoolean(R.styleable.WheelView_isClockwise, true);
            this.attrRotateDegree = a.getInt(R.styleable.WheelView_rotateDegree, 45);
            this.attrScalePointer = a.getFloat(R.styleable.WheelView_scalePointer, 0.5f);
            this.attrDelayEndTime = a.getInt(R.styleable.WheelView_delayEndTime, 0);
        }
        finally {
            a.recycle();
        }
        if (this.attrScalePointer > 1.0f) {
            this.attrScalePointer = 1.0f;
        }
        if (this.attrScalePointer < 0.0f) {
            this.attrScalePointer = 0.0f;
        }
        if (this.attrDelayEndTime < 0) {
            this.attrDelayEndTime = 0;
        }
        if (!this.attrIsClockwise) {
            this.attrRotateDegree *= -1;
        }
        this.soundId = this.soundEffect.load(context, R.raw.wheel_spin, 1);
        this.handler = new Handler();
    }

    public void setDrawableWheel(int resId) {
        this.attrDrawableWheel = resId;
    }

    public int getDrawableWheel() {
        return this.attrDrawableWheel;
    }

    public void setDrawablePointer(int resId) {
        this.attrDrawablePointer = resId;
    }

    public int getDrawablePointer() {
        return this.attrDrawablePointer;
    }

    public void setClockwise(boolean isClockwise) {
        this.attrIsClockwise = isClockwise;
    }

    public boolean getClockwise() {
        return this.attrIsClockwise;
    }

    public void setRotateDegree(int degree) {
        this.attrRotateDegree = !this.attrIsClockwise ? degree * -1 : degree;
    }

    public int getRotateDegree() {
        return this.attrRotateDegree;
    }

    public void setScalePointer(float scale) {
        this.attrScalePointer = scale;
        if (this.attrScalePointer > 1.0f) {
            this.attrScalePointer = 1.0f;
        }
        if (this.attrScalePointer < 0.0f) {
            this.attrScalePointer = 0.0f;
        }
    }

    public float getScalePointer() {
        return this.attrScalePointer;
    }

    public void setDelayEndTime(int time) {
        this.attrDelayEndTime = time;
        if (this.attrDelayEndTime < 0) {
            this.attrDelayEndTime = 0;
        }
    }

    public int getDelayEndTime() {
        return this.attrDelayEndTime;
    }

    public void setOnSpinListener(OnSpinListener listener) {
        this.spinListener = listener;
    }

    public void setOnTouchSpinListener(OnTouchSpinListener listener) {
        this.touchSpinListener = listener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mWheelDrawable.draw(canvas);
        this.mPointerDrawable.draw(canvas);
        if (this.touchSpinListener != null) {
            this.setOnTouchListener(this);
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.wheelBitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.attrDrawableWheel);
        this.wheelBitmap = Bitmap.createScaledBitmap((Bitmap)this.wheelBitmap, (int)parentWidth, (int)parentWidth, (boolean)false);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap tmp = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.attrDrawablePointer, (BitmapFactory.Options)options);
        int pointerHeight = options.outHeight;
        int pointerWidth = options.outWidth;
        int newPointerWidth = (int)((float)parentWidth * this.attrScalePointer);
        int newPointerHeight = (int)((float)pointerHeight / (float)pointerWidth * (float)newPointerWidth);
        this.pointerX = parentWidth / 2 - newPointerWidth / 2;
        this.pointerY = parentWidth / 2 - newPointerHeight / 2;
        options = null;
        tmp = null;
        this.pointerBitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.attrDrawablePointer);
        this.pointerBitmap = Bitmap.createScaledBitmap((Bitmap)this.pointerBitmap, (int)newPointerWidth, (int)newPointerHeight, (boolean)false);
        this.setMeasuredDimension(parentWidth, parentWidth);
        this.wheelMovingDot = this.context.getResources().getDrawable(this.attrDrawableWheel);
        this.wheelMovingDot.setBounds(0, 0, this.wheelBitmap.getWidth(), this.wheelBitmap.getHeight());
        this.rotate(0.0f, 0.0f, 50);
        this.pointerMovingDot = this.context.getResources().getDrawable(this.attrDrawablePointer);
        this.pointerMovingDot.setBounds(this.pointerX, this.pointerY, this.pointerBitmap.getWidth() + this.pointerX, this.pointerBitmap.getHeight() + this.pointerY);
        this.meter(0, 0.0f, 50);
    }

    private void rotate(float startAngle, float endAngle, int duration) {
        this.anWheel = new rotateAnimation(startAngle, endAngle, 0, this.wheelBitmap.getWidth() / 2, 0, this.wheelBitmap.getHeight() / 2);
        this.anWheel.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.anWheel.setDuration(duration);
        this.anWheel.setFillEnabled(true);
        this.anWheel.setFillAfter(true);
        this.anWheel.setRepeatCount(0);
        this.anWheel.initialize(0, 0, this.wheelBitmap.getWidth(), this.wheelBitmap.getHeight());
        this.setFocusable(true);
        this.mWheelDrawable = new AnimateDrawable(this.wheelMovingDot, (Animation)this.anWheel);
        this.anWheel.startNow();
    }

    private void meter(int round, float endAngle, int duration) {
        if (round <= 0) {
            round = 1;
        }
        this.anPointer = new rotateAnimation(0.0f, endAngle, 0, this.pointerBitmap.getWidth() / 2 + this.pointerX, 0, this.pointerBitmap.getHeight() / 2 + this.pointerY);
        this.anPointer.setInterpolator((Interpolator)new LinearInterpolator());
        this.anPointer.setDuration((int)((double)duration / ((double)round * 1.2)));
        this.anPointer.setFillEnabled(true);
        this.anPointer.setFillAfter(true);
        this.anPointer.setRepeatCount(round - 1);
        this.anPointer.initialize(0, 0, this.pointerBitmap.getWidth(), this.pointerBitmap.getHeight());
        this.mPointerDrawable = new AnimateDrawable(this.pointerMovingDot, (Animation)this.anPointer);
        this.anPointer.startNow();
    }

    public void startSpin(float startAngle, float endAngle) {
        if (!this.isSpining) {
            this.isSpining = true;
            final float lastAngle = endAngle;
            endAngle = this.attrIsClockwise ? (float)(360 * this.spin_round) + endAngle : ((float)(360 * this.spin_round) - endAngle) * -1.0f;
            this.rotate(startAngle, endAngle, this.duration);
            this.meter(this.spin_round, this.attrRotateDegree, this.duration);
            this.anPointer.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    WheelView.this.meter(0, 0.0f, 0);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.anWheel.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    WheelView.this.streamId = WheelView.this.soundEffect.play(WheelView.this.soundId, 1.0f, 1.0f, 1, 0, 1.0f);
                }

                public void onAnimationEnd(Animation animation) {
                    WheelView.this.meter(0, 0.0f, 0);
                    WheelView.this.soundEffect.stop(WheelView.this.streamId);
                    WheelView.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (WheelView.this.spinListener != null) {
                                WheelView.this.spinListener.onSpin(lastAngle);
                            }
                            WheelView.this.isSpining = false;
                        }
                    }, (long)WheelView.this.attrDelayEndTime);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            Log.e((String)"WHEELVIEW", (String)"IS SPINING");
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0) {
            float eventX = event.getX() - 20.0f;
            float eventY = event.getY() - 20.0f;
            if (eventX > (float)this.pointerX && eventX < (float)(this.pointerX + this.pointerBitmap.getWidth()) && eventY > (float)this.pointerY && eventY < (float)(this.pointerY + this.pointerBitmap.getHeight())) {
                this.touchSpinListener.onTouchSpin(event);
            }
            return true;
        }
        return false;
    }

    private boolean tabOnBitmap(AnimateDrawable bitmap, MotionEvent event) {
        return false;
    }

    public static interface OnTouchSpinListener {
        public void onTouchSpin(MotionEvent var1);
    }

    public static interface OnSpinListener {
        public void onSpin(float var1);
    }

    private static class rotateAnimation
    extends RotateAnimation {
        public rotateAnimation(float fromDegrees, float toDegrees, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
            super(fromDegrees, toDegrees, pivotXType, pivotXValue, pivotYType, pivotYValue);
        }

        public rotateAnimation(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void cancel() {
            Log.e((String)"Cancel ", (String)"Cacel ");
            super.cancel();
        }
    }
}

