/*
 * Decompiled with CFR 0.152.
 */
package me.decimo.app.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;

public class ProxyDrawable
extends Drawable {
    private Drawable mProxy;
    private boolean mMutated;

    public ProxyDrawable(Drawable target) {
        this.mProxy = target;
    }

    public Drawable getProxy() {
        return this.mProxy;
    }

    public void setProxy(Drawable proxy) {
        if (proxy != this) {
            this.mProxy = proxy;
        }
    }

    public void draw(Canvas canvas) {
        if (this.mProxy != null) {
            this.mProxy.draw(canvas);
        }
    }

    public int getIntrinsicWidth() {
        return this.mProxy != null ? this.mProxy.getIntrinsicWidth() : -1;
    }

    public int getIntrinsicHeight() {
        return this.mProxy != null ? this.mProxy.getIntrinsicHeight() : -1;
    }

    public int getOpacity() {
        return this.mProxy != null ? this.mProxy.getOpacity() : -2;
    }

    public void setFilterBitmap(boolean filter) {
        if (this.mProxy != null) {
            this.mProxy.setFilterBitmap(filter);
        }
    }

    public void setDither(boolean dither) {
        if (this.mProxy != null) {
            this.mProxy.setDither(dither);
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mProxy != null) {
            this.mProxy.setColorFilter(colorFilter);
        }
    }

    public void setAlpha(int alpha) {
        if (this.mProxy != null) {
            this.mProxy.setAlpha(alpha);
        }
    }

    public Drawable mutate() {
        if (this.mProxy != null && !this.mMutated && super.mutate() == this) {
            this.mProxy.mutate();
            this.mMutated = true;
        }
        return this;
    }
}

