/*
 * Decompiled with CFR 0.152.
 */
package me.decimo.app.widget;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import me.decimo.app.widget.ProxyDrawable;

public class AnimateDrawable
extends ProxyDrawable {
    private Animation mAnimation;
    private Transformation mTransformation = new Transformation();

    public AnimateDrawable(Drawable target) {
        super(target);
    }

    public AnimateDrawable(Drawable target, Animation animation) {
        super(target);
        this.mAnimation = animation;
    }

    public Animation getAnimation() {
        return this.mAnimation;
    }

    public void setAnimation(Animation anim) {
        this.mAnimation = anim;
    }

    public boolean hasStarted() {
        return this.mAnimation != null && this.mAnimation.hasStarted();
    }

    public boolean hasEnded() {
        return this.mAnimation == null || this.mAnimation.hasEnded();
    }

    @Override
    public void draw(Canvas canvas) {
        Drawable dr = this.getProxy();
        if (dr != null) {
            int sc = canvas.save();
            Animation anim = this.mAnimation;
            if (anim != null) {
                anim.getTransformation(AnimationUtils.currentAnimationTimeMillis(), this.mTransformation);
                canvas.concat(this.mTransformation.getMatrix());
            }
            dr.draw(canvas);
            canvas.restoreToCount(sc);
        }
    }
}

