/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import me.czmc.library.widget.R;

public class RadiusImageView
extends ImageView {
    private Paint paint;
    private int mRadius = 20;

    public RadiusImageView(Context context) {
        this(context, null);
    }

    public RadiusImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RadiusImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.RadiusImageView);
        this.mRadius = (int)ta.getDimension(R.styleable.RadiusImageView_radius, (float)this.mRadius);
        ta.recycle();
        this.paint = new Paint();
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        if (null != drawable2) {
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            Bitmap b = this.getRoundBitmap(bitmap, this.mRadius);
            Rect rectSrc = new Rect(0, 0, b.getWidth(), b.getHeight());
            Rect rectDest = new Rect(0, 0, this.getWidth(), this.getHeight());
            this.paint.reset();
            canvas.drawBitmap(b, rectSrc, rectDest, this.paint);
        } else {
            super.onDraw(canvas);
        }
    }

    private Bitmap getRoundBitmap(Bitmap bitmap, int roundPx) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        this.paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        this.paint.setColor(-12434878);
        int x = bitmap.getWidth();
        canvas.drawRoundRect(rectF, (float)roundPx, (float)roundPx, this.paint);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, this.paint);
        return output;
    }
}

