/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ScrollView;

public class BounceScrollView
extends ScrollView {
    private View inner;
    private float y;
    private Rect normal = new Rect();
    private boolean isCount = false;
    private OriLister mOriLister;

    public BounceScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        if (this.getChildCount() > 0) {
            this.inner = this.getChildAt(0);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.inner != null) {
            this.commOnTouchEvent(ev);
        }
        return super.onTouchEvent(ev);
    }

    public void setLiSten(OriLister oriLister) {
        this.mOriLister = oriLister;
    }

    public void commOnTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.isNeedAnimation()) break;
                this.animation();
                this.isCount = false;
                break;
            }
            case 2: {
                float preY = this.y;
                float nowY = ev.getY();
                int deltaY = (int)(preY - nowY);
                if (!this.isCount) {
                    deltaY = 0;
                }
                this.y = nowY;
                if (this.isNeedMove()) {
                    if (this.normal.isEmpty()) {
                        this.normal.set(this.inner.getLeft(), this.inner.getTop(), this.inner.getRight(), this.inner.getBottom());
                    }
                    this.inner.layout(this.inner.getLeft(), this.inner.getTop() - deltaY / 2, this.inner.getRight(), this.inner.getBottom() - deltaY / 2);
                }
                this.isCount = true;
                break;
            }
        }
    }

    public void animation() {
        TranslateAnimation ta = new TranslateAnimation(0.0f, 0.0f, (float)this.inner.getTop(), (float)this.normal.top);
        ta.setDuration(200L);
        this.inner.startAnimation((Animation)ta);
        this.inner.layout(this.normal.left, this.normal.top, this.normal.right, this.normal.bottom);
        this.normal.setEmpty();
    }

    public boolean isNeedAnimation() {
        return !this.normal.isEmpty();
    }

    public boolean isNeedMove() {
        int offset = this.inner.getMeasuredHeight() - this.getHeight();
        int scrollY = this.getScrollY();
        if (scrollY == 0 || scrollY == offset) {
            if (scrollY == 0) {
                // empty if block
            }
            if (scrollY == offset) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public static interface OriLister {
        public void addMore();

        public void refresh();
    }
}

