package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RadiusImageView extends ImageView {

    private Paint paint;
    private int mRadius = 20;
    
    public RadiusImageView(Context context) {
        this(context,null);  
    }  
  
    public RadiusImageView(Context context, AttributeSet attrs) {
        this(context, attrs,0);  
    }  
  
    public RadiusImageView(Context context, AttributeSet attrs, int defStyle) {

        super(context, attrs, defStyle);
        TypedArray ta = getResources().obtainAttributes(attrs,R.styleable.RadiusImageView);
          mRadius = (int) ta.getDimension(R.styleable.RadiusImageView_radius,mRadius);
        ta.recycle();
        paint  = new Paint();
    }  
  
    /**
     * 绘制圆角矩形图片
     * @author caizhiming
     */
    @Override  
    protected void onDraw(Canvas canvas) {
  
        Drawable drawable = getDrawable();
        if (null != drawable) {  
            Bitmap bitmap = ((BitmapDrawable) drawable).getBitmap();
            Bitmap b = getRoundBitmap(bitmap, mRadius);
            final Rect rectSrc = new Rect(0, 0, b.getWidth(), b.getHeight());
            final Rect rectDest = new Rect(0,0,getWidth(),getHeight());
            paint.reset();  
            canvas.drawBitmap(b, rectSrc, rectDest, paint);  
        } else {
            super.onDraw(canvas);  
        }  
    }  
  
    /**
     * 获取圆角矩形图片方法
     * @param bitmap
     * @param roundPx,一般设置成14
     * @return Bitmap
     * @author caizhiming
     */
    private Bitmap getRoundBitmap(Bitmap bitmap, int roundPx) {  
        Bitmap output = Bitmap.createBitmap(bitmap.getWidth(),  
                bitmap.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);  
          
        final int color = 0xff424242;
       
        final Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());  
        final RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);  
        canvas.drawARGB(0, 0, 0, 0);  
        paint.setColor(color);  
        int x = bitmap.getWidth(); 
        
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);  
        return output;  

    }  
}  