/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.czmc.library.widget.R;

public class ViewPagerIndicator
extends LinearLayout
implements ViewPager.OnPageChangeListener,
View.OnClickListener {
    private Paint mIndicatorPaint;
    private int mIndicatorColor;
    private int mHighLightTextColor;
    private int mDefaultTextColor;
    private float mIndicatorHeight;
    private float mIndicatorWidth;
    private int mVisibleMenuCount;
    private int mIndicatorLimit;
    private int mFirstPosition;
    private int mCurrentPosition;
    private int mChildHeight;
    private int mChildWidth;
    private float mStartX;
    private float mStartY;
    private float moveDelta = 0.0f;
    private int showWidth;
    private ViewPager mViewPager;
    private View lastChild;
    private int mIndicatorType;
    private float mTextSize;

    public ViewPagerIndicator(Context context) {
        super(context);
        this.init(null);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        Log.i((String)"Indicator", (String)"init");
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.ViewPagerIndicator);
        this.mIndicatorColor = ta.getColor(R.styleable.ViewPagerIndicator_indicatorColor, Color.parseColor((String)"#ffffff"));
        this.mHighLightTextColor = ta.getColor(R.styleable.ViewPagerIndicator_highLightTextColor, Color.parseColor((String)"#ffffff"));
        this.mDefaultTextColor = ta.getColor(R.styleable.ViewPagerIndicator_defaultTextColor, Color.parseColor((String)"#ffffff"));
        this.mIndicatorHeight = ta.getDimension(R.styleable.ViewPagerIndicator_indicatorHeight, 30.0f);
        this.mIndicatorWidth = ta.getDimension(R.styleable.ViewPagerIndicator_indicatorWidth, 30.0f);
        this.mVisibleMenuCount = ta.getInt(R.styleable.ViewPagerIndicator_visibleMenuCount, 3);
        this.mIndicatorLimit = ta.getInt(R.styleable.ViewPagerIndicator_indicatorLimit, 2);
        this.mFirstPosition = ta.getInt(R.styleable.ViewPagerIndicator_firstPosition, 0);
        this.mIndicatorType = ta.getInt(R.styleable.ViewPagerIndicator_indicatorType, 0);
        this.mTextSize = ta.getDimension(R.styleable.ViewPagerIndicator_textsize, 25.0f);
        ta.recycle();
        this.setOrientation(0);
        this.mIndicatorPaint = new Paint();
        this.mIndicatorPaint.setAntiAlias(true);
        this.mIndicatorPaint.setColor(this.mIndicatorColor);
        this.mIndicatorLimit = Math.min(this.mVisibleMenuCount - 1, this.mIndicatorLimit);
        this.mCurrentPosition = this.mFirstPosition;
    }

    public void setViewPager(ViewPager viewpager) {
        Log.i((String)"Indicator", (String)"setViewPager");
        this.mViewPager = viewpager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        if (this.mViewPager != null) {
            for (int i = 0; i < this.mViewPager.getAdapter().getCount(); ++i) {
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
                TextView textView = new TextView(this.getContext());
                textView.setTextColor(this.mDefaultTextColor);
                textView.setTextSize(0, this.mTextSize);
                textView.setText(this.mViewPager.getAdapter().getPageTitle(i));
                textView.setGravity(17);
                this.addView((View)textView, layoutParams);
            }
        }
    }

    protected void onAttachedToWindow() {
        if (this.mViewPager != null) {
            if (this.mCurrentPosition == 0) {
                this.onPageSelected(this.mCurrentPosition);
            }
            this.mViewPager.setCurrentItem(this.mCurrentPosition);
        }
        super.onAttachedToWindow();
    }

    protected void onDraw(Canvas canvas) {
        this.drawIndicator(canvas);
        super.onDraw(canvas);
    }

    private void drawIndicator(Canvas canvas) {
        switch (this.mIndicatorType) {
            case 0: {
                Path path = new Path();
                path.moveTo(this.mStartX + this.moveDelta, this.mStartY - this.mIndicatorHeight);
                path.lineTo(this.mStartX + this.moveDelta - this.mIndicatorWidth / 2.0f, this.mStartY);
                path.lineTo(this.mStartX + this.moveDelta - this.mIndicatorWidth, this.mStartY - this.mIndicatorHeight);
                path.lineTo(this.mStartX + this.moveDelta, this.mStartY - this.mIndicatorHeight);
                canvas.drawPath(path, this.mIndicatorPaint);
                break;
            }
            case 1: {
                canvas.drawRect(this.mStartX + this.moveDelta - this.mIndicatorWidth, this.mStartY - this.mIndicatorHeight, this.mStartX + this.moveDelta, this.mStartY, this.mIndicatorPaint);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.showWidth = this.getMeasuredWidth();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Log.i((String)"Indicator", (String)"onSizeChanged");
        super.onSizeChanged(w, h, oldw, oldh);
        int maxTriAngerHeight = (h - this.mChildHeight) / 2;
        int maxTriAngerWidth = w / this.mVisibleMenuCount / 2;
        this.mIndicatorHeight = Math.min(this.mIndicatorHeight, (float)maxTriAngerHeight);
        this.mIndicatorWidth = Math.min(this.mIndicatorWidth, (float)maxTriAngerWidth);
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            this.mChildHeight = child.getMeasuredHeight();
            this.mChildWidth = this.showWidth / this.mVisibleMenuCount;
            for (int i = 0; i < this.getChildCount(); ++i) {
                child = this.getChildAt(i);
                child.getLayoutParams().width = this.mChildWidth;
                child.setClickable(true);
                child.setTag((Object)i);
                child.setOnClickListener((View.OnClickListener)this);
            }
        }
        this.setMeasuredDimension(this.getChildCount() * this.mChildWidth, this.getMeasuredHeight());
        this.mStartX = (float)(this.mChildWidth / 2) + this.mIndicatorWidth / 2.0f + (float)this.getPaddingLeft();
        this.moveDelta = this.mCurrentPosition * this.mChildWidth;
        this.mStartY = this.getMeasuredHeight();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mIndicatorLimit <= 0) {
            return;
        }
        float moveX = (float)this.mChildWidth * ((float)position + positionOffset);
        if ((float)position + positionOffset >= (float)(this.mIndicatorLimit - 1) && (float)position + positionOffset <= (float)(this.getChildCount() - 1 - (this.mVisibleMenuCount - this.mIndicatorLimit))) {
            this.scrollTo((int)moveX - (this.mIndicatorLimit - 1) * this.mChildWidth, 0);
        }
        this.moveDelta = moveX;
        this.invalidate();
    }

    public void onPageSelected(int position) {
        this.mCurrentPosition = position;
        View child = this.getChildAt(position);
        if (child == null) {
            return;
        }
        ((TextView)child).setTextColor(this.mHighLightTextColor);
        if (this.lastChild != null) {
            ((TextView)this.lastChild).setTextColor(this.mDefaultTextColor);
        }
        this.lastChild = child;
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onClick(View v) {
        int index = (Integer)v.getTag();
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(index);
        }
    }
}

