/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import me.czmc.library.adapter.recyclerview.ItemViewDelegate;
import me.czmc.library.adapter.recyclerview.ItemViewDelegateManager;
import me.czmc.library.adapter.recyclerview.ViewHolder;

public class MultiItemTypeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context mContext;
    protected List<T> mDatas = new ArrayList<T>();
    protected ItemViewDelegateManager mItemViewDelegateManager;
    protected OnItemClickListener<T> mOnItemClickListener;

    public MultiItemTypeAdapter(Context context, List<T> datas) {
        this.mContext = context;
        this.mDatas = datas;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public MultiItemTypeAdapter(Context context) {
        this.mContext = context;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public int getItemViewType(int position) {
        if (!this.useItemViewDelegateManager()) {
            return super.getItemViewType(position);
        }
        return this.mItemViewDelegateManager.getItemViewType(this.mDatas.get(position), position);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int layoutId = this.mItemViewDelegateManager.getItemViewLayoutId(viewType);
        ViewHolder holder = ViewHolder.createViewHolder(this.mContext, parent, layoutId);
        this.setListener(parent, holder, viewType);
        return holder;
    }

    public void convert(ViewHolder holder, T t) {
        this.mItemViewDelegateManager.convert(holder, t, holder.getAdapterPosition());
    }

    protected boolean isEnabled(int viewType) {
        return true;
    }

    protected void setListener(ViewGroup parent, final ViewHolder viewHolder, int viewType) {
        if (!this.isEnabled(viewType)) {
            return;
        }
        viewHolder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    MultiItemTypeAdapter.this.mOnItemClickListener.onItemClick(v, viewHolder, MultiItemTypeAdapter.this.mDatas.get(position), position);
                }
            }
        });
        viewHolder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    return MultiItemTypeAdapter.this.mOnItemClickListener.onItemLongClick(v, viewHolder, MultiItemTypeAdapter.this.mDatas.get(position), position);
                }
                return false;
            }
        });
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.convert(holder, this.mDatas.get(position));
    }

    public int getItemCount() {
        int itemCount = this.mDatas.size();
        return itemCount;
    }

    public List<T> getDatas() {
        return this.mDatas;
    }

    public MultiItemTypeAdapter addItemViewDelegate(ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(itemViewDelegate);
        return this;
    }

    public MultiItemTypeAdapter addItemViewDelegate(int viewType, ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(viewType, itemViewDelegate);
        return this;
    }

    protected boolean useItemViewDelegateManager() {
        return this.mItemViewDelegateManager.getItemViewDelegateCount() > 0;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setData(List<T> list) {
        if (list != null && list.size() > 0) {
            this.mDatas.clear();
            this.mDatas.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void clearAll() {
        if (this.mDatas != null) {
            this.mDatas.clear();
        }
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(View var1, RecyclerView.ViewHolder var2, T var3, int var4);

        public boolean onItemLongClick(View var1, RecyclerView.ViewHolder var2, T var3, int var4);
    }
}

