/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.adapter.custom;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import me.czmc.library.adapter.custom.ItemViewDelegate;
import me.czmc.library.adapter.custom.ItemViewDelegateManager;
import me.czmc.library.adapter.custom.ViewHolder;

public class MultiItemTypeAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    protected List<T> mDatas = new ArrayList<T>();
    private ItemViewDelegateManager mItemViewDelegateManager;

    public MultiItemTypeAdapter(Context context, List<T> datas) {
        this.mContext = context;
        this.mDatas = datas;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public MultiItemTypeAdapter(Context context) {
        this.mContext = context;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public MultiItemTypeAdapter addItemViewDelegate(ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(itemViewDelegate);
        return this;
    }

    private boolean useItemViewDelegateManager() {
        return this.mItemViewDelegateManager.getItemViewDelegateCount() > 0;
    }

    public int getViewTypeCount() {
        if (this.useItemViewDelegateManager()) {
            return this.mItemViewDelegateManager.getItemViewDelegateCount();
        }
        return super.getViewTypeCount();
    }

    public int getItemViewType(int position) {
        if (this.useItemViewDelegateManager()) {
            int viewType = this.mItemViewDelegateManager.getItemViewType(this.mDatas.get(position), position);
            return viewType;
        }
        return super.getItemViewType(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int layoutId = this.mItemViewDelegateManager.getItemViewLayoutId(this.mDatas.get(position), position);
        ViewHolder viewHolder = ViewHolder.get(this.mContext, convertView, parent, layoutId, position);
        this.convert(viewHolder, this.getItem(position), position);
        return viewHolder.getConvertView();
    }

    protected void convert(ViewHolder viewHolder, T item, int position) {
        this.mItemViewDelegateManager.convert(viewHolder, item, position);
    }

    public int getCount() {
        return this.mDatas.size();
    }

    public T getItem(int position) {
        return this.mDatas.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setData(List<T> list) {
        if (list != null && list.size() > 0) {
            this.mDatas.clear();
            this.mDatas.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void clearAll() {
        if (this.mDatas != null) {
            this.mDatas.clear();
        }
    }
}

