/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import me.czmc.library.utils.DisplayUtil;
import me.czmc.library.widget.R;

public class EditTextWithCounter
extends EditText {
    private Paint mCounterPaint;
    private int mCurrentTextLength;
    private int mCounterTextColor;
    private int mCounterTextSize;
    private int mLimit;
    private int defaultPadding = DisplayUtil.dip2px(this.getContext(), 5.0f);
    private String mContent = "0";
    public int MAXLINES = 2;

    public int getmLimit() {
        return this.mLimit;
    }

    public void setmLimit(int mLimit) {
        this.mLimit = mLimit;
    }

    public int getmCurrentTextLength() {
        return this.mCurrentTextLength;
    }

    public void setmCurrentTextLength(int mCurrentTextLength) {
        this.mCurrentTextLength = mCurrentTextLength;
    }

    public int getmCounterTextColor() {
        return this.mCounterTextColor;
    }

    public void setmCounterTextColor(int mCounterTextColor) {
        this.mCounterTextColor = mCounterTextColor;
    }

    public int getmCounterTextSize() {
        return this.mCounterTextSize;
    }

    public void setmCounterTextSize(int mCounterTextSize) {
        this.mCounterTextSize = mCounterTextSize;
    }

    public EditTextWithCounter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public EditTextWithCounter(Context context) {
        super(context);
        this.init(null);
    }

    public EditTextWithCounter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.EditTextWithCounter);
        this.mCounterTextColor = ta.getColor(R.styleable.EditTextWithCounter_counterColor, -7829368);
        this.mCounterTextSize = ta.getColor(R.styleable.EditTextWithCounter_counterSize, DisplayUtil.dip2px(this.getContext(), 16.0f));
        this.mLimit = ta.getInt(R.styleable.EditTextWithCounter_limit, -1);
        ta.recycle();
        this.setGravity(0x800003);
        this.mCounterPaint = new Paint();
        this.mCounterPaint.setColor(this.mCounterTextColor);
        this.mCounterPaint.setTextSize((float)this.mCounterTextSize);
        this.mCounterPaint.setAntiAlias(true);
        this.setPadding(this.defaultPadding, this.defaultPadding, this.defaultPadding, this.defaultPadding + (int)this.mCounterPaint.getTextSize());
        if (this.mLimit >= 0) {
            this.mContent = "0/" + this.mLimit;
        }
        this.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.white_card_state));
        this.initEvent();
    }

    private void initEvent() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                EditTextWithCounter.this.mCurrentTextLength = s.length();
                if (EditTextWithCounter.this.mLimit != -1) {
                    if (s.length() > EditTextWithCounter.this.mLimit) {
                        int cursorEnd;
                        String str = s.toString();
                        int cursorStart = EditTextWithCounter.this.getSelectionStart();
                        str = cursorStart == (cursorEnd = EditTextWithCounter.this.getSelectionEnd()) && cursorStart < str.length() && cursorStart >= 1 ? str.substring(0, cursorStart - 1) + str.substring(cursorStart) : str.substring(0, s.length() - 1);
                        EditTextWithCounter.this.setText(str);
                        EditTextWithCounter.this.setSelection(EditTextWithCounter.this.getText().length());
                    }
                    EditTextWithCounter.this.mContent = EditTextWithCounter.this.mCurrentTextLength + "/" + EditTextWithCounter.this.mLimit;
                } else {
                    EditTextWithCounter.this.mContent = EditTextWithCounter.this.mCurrentTextLength + "";
                }
                EditTextWithCounter.this.postInvalidate();
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawText(this.mContent, (float)this.getRight() - this.mCounterPaint.getTextSize() / 2.0f * (float)this.mContent.length() - (float)this.getPaddingRight(), (float)(this.getHeight() - this.getPaddingBottom()) + this.mCounterPaint.getTextSize(), this.mCounterPaint);
    }
}

