/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.igp.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import me.champeau.gradle.igp.Authentication;
import me.champeau.gradle.igp.IncludedGitRepo;
import me.champeau.gradle.igp.internal.DefaultAuthentication;
import org.gradle.api.Action;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.Settings;
import org.gradle.api.model.ObjectFactory;

public abstract class DefaultIncludedGitRepo
implements IncludedGitRepo {
    private final String name;
    private final ObjectFactory objects;
    private final Action<ConfigurableIncludedBuild> rootSpec;
    private final List<IncludedBuild> includes = new ArrayList<IncludedBuild>();
    private final List<Action<? super IncludedGitRepo.CodeReadyEvent>> codeReadyEvents = new ArrayList<Action<? super IncludedGitRepo.CodeReadyEvent>>();
    private DefaultAuthentication auth;

    @Inject
    public DefaultIncludedGitRepo(String name, ObjectFactory objects) {
        this.name = name;
        this.objects = objects;
        this.rootSpec = c -> c.setName(name);
        this.getAutoInclude().convention((Object)true);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void includeBuild(Action<? super ConfigurableIncludedBuild> spec) {
        this.includeBuild(".", (Action<? super ConfigurableIncludedBuild>)((Action)c -> {
            this.rootSpec.execute(c);
            spec.execute(c);
        }));
    }

    @Override
    public void codeReady(Action<? super IncludedGitRepo.CodeReadyEvent> configuration) {
        this.codeReadyEvents.add(configuration);
    }

    @Override
    public void includeBuild(String relativePath, Action<? super ConfigurableIncludedBuild> spec) {
        if (((Boolean)this.getAutoInclude().get()).booleanValue()) {
            this.getAutoInclude().set((Object)false);
            this.getAutoInclude().finalizeValue();
        }
        this.includes.add(new IncludedBuild(relativePath, spec));
    }

    @Override
    public void authentication(Action<? super Authentication> config) {
        if (this.auth == null) {
            this.auth = (DefaultAuthentication)this.objects.newInstance(DefaultAuthentication.class, new Object[0]);
        }
        config.execute((Object)this.auth);
    }

    Optional<DefaultAuthentication> getAuth() {
        return Optional.ofNullable(this.auth);
    }

    void configure(Settings settings, File checkoutDirectory) {
        if (!this.codeReadyEvents.isEmpty()) {
            this.fireCodeReadyEvents(checkoutDirectory);
        }
        if (((Boolean)this.getAutoInclude().get()).booleanValue()) {
            settings.includeBuild((Object)checkoutDirectory, this.rootSpec);
        } else {
            for (IncludedBuild include : this.includes) {
                settings.includeBuild((Object)new File(checkoutDirectory, include.directory), include.spec);
            }
        }
    }

    private void fireCodeReadyEvents(final File checkoutDirectory) {
        IncludedGitRepo.CodeReadyEvent codeReadyEvent = new IncludedGitRepo.CodeReadyEvent(){

            @Override
            public IncludedGitRepo getIncludedGitRepo() {
                return DefaultIncludedGitRepo.this;
            }

            @Override
            public File getCheckoutDirectory() {
                return checkoutDirectory;
            }
        };
        for (Action<? super IncludedGitRepo.CodeReadyEvent> action : this.codeReadyEvents) {
            action.execute((Object)codeReadyEvent);
        }
    }

    private static class IncludedBuild {
        private final String directory;
        private final Action<? super ConfigurableIncludedBuild> spec;

        private IncludedBuild(String directory, Action<? super ConfigurableIncludedBuild> spec) {
            this.directory = directory;
            this.spec = spec;
        }
    }
}

