/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.spring.aws.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.ccampo.spring.aws.lambda.SpringRequestStreamHandler;
import org.jetbrains.annotations.NotNull;

public abstract class JacksonSpringRequestHandler<I, O>
extends SpringRequestStreamHandler {
    private final Class<I> inputClass;
    private final RequestHandler handler;

    protected JacksonSpringRequestHandler(@NotNull Class<I> inputClass) {
        this.inputClass = inputClass;
        this.handler = (RequestHandler)this.getApplicationContext().getBean(RequestHandler.class);
    }

    protected abstract ObjectMapper getObjectMapper();

    @Override
    public void handleRequest(@NotNull InputStream input, @NotNull OutputStream output, @NotNull Context context) throws IOException {
        Object inObject = this.getObjectMapper().readValue(input, this.inputClass);
        Object outObject = this.handler.handleRequest(inObject, context);
        this.getObjectMapper().writeValue(output, outObject);
    }
}

