/*
 * Decompiled with CFR 0.152.
 */
package me.ddzq.android.deerconvetor.lib.convertor;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.ddzq.android.deerconvetor.lib.annotation.CollectionInitBy;
import me.ddzq.android.deerconvetor.lib.annotation.NickName;
import me.ddzq.android.deerconvetor.lib.annotation.NotConvert;
import me.ddzq.android.deerconvetor.lib.annotation.SerializeBy;
import me.ddzq.android.deerconvetor.lib.serializer.Serializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonDeer {
    private static JsonDeer jsonConvertor;
    static String CLASS_PREFIX;
    static String INTERFACE_PREFIX;

    private static JsonDeer getInstance() {
        if (null != jsonConvertor) {
            return jsonConvertor;
        }
        jsonConvertor = new JsonDeer();
        return jsonConvertor;
    }

    public static <T> T fromJson(JSONObject jsonObject, Class type) {
        return JsonDeer.getInstance().jsonToBean(jsonObject, type);
    }

    public static <T> Collection<T> fromJsonArray(JSONArray array, Class type) {
        return JsonDeer.getInstance().jsonArrayToBeanList(array, type);
    }

    public static <T> JSONObject toJson(T t) {
        return JsonDeer.getInstance().beanToJson(t);
    }

    private <T> T jsonToBean(JSONObject jsonObject, Class type) {
        T t = null;
        try {
            t = type.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != t) {
            t = this.parseEntity(jsonObject, t);
            return t;
        }
        return null;
    }

    private <T> Collection<T> jsonArrayToBeanList(JSONArray array, Class type) {
        Collection collection = new ArrayList();
        BasicType basicType = this.isBasicType(type);
        try {
            collection = basicType != BasicType.OTHER_TYPE ? this.setCollectionBasicValue(collection, array, type) : this.setCollectionCustomValue(collection, array, type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collection;
    }

    private <T> JSONObject beanToJson(T t) {
        Field[] fields;
        JSONObject jsonObject = new JSONObject();
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(NotConvert.class)) continue;
            field.setAccessible(true);
            String name = field.getName();
            if (field.isAnnotationPresent(NickName.class)) {
                name = field.getAnnotation(NickName.class).value();
            }
            try {
                Object value = this.parseFieldValue(field, t);
                if (null == value || value.equals("null")) {
                    jsonObject.put(name, (Object)"");
                    continue;
                }
                jsonObject.put(name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jsonObject;
    }

    private <T> T parseEntity(JSONObject jsonObject, T t) {
        Field[] fields;
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(NotConvert.class)) continue;
            this.parseField(field, jsonObject, t);
        }
        return t;
    }

    private <T> void parseField(Field field, JSONObject jsonObject, T t) {
        block12: {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            Type fieldGenericType = field.getGenericType();
            String fieldName = field.getName();
            if (field.isAnnotationPresent(NickName.class)) {
                fieldName = field.getAnnotation(NickName.class).value();
            }
            try {
                if (field.isAnnotationPresent(SerializeBy.class)) {
                    Class s = field.getAnnotation(SerializeBy.class).value();
                    Serializer serializer = (Serializer)s.newInstance();
                    field.set(t, serializer.deserialization(jsonObject.getString(fieldName)));
                    return;
                }
                if (fieldType == fieldGenericType) {
                    BasicType basicType = this.isBasicType(fieldType);
                    if (basicType != BasicType.OTHER_TYPE) {
                        this.setBasicValue(field, jsonObject, t, fieldName, basicType);
                    } else {
                        this.setCustomValue(field, jsonObject, t, fieldType, fieldName);
                    }
                } else {
                    ParameterizedType integerListType = (ParameterizedType)fieldGenericType;
                    Type genericType = integerListType.getActualTypeArguments()[0];
                    BasicType basicType = this.isBasicType(genericType);
                    Collection collection = null;
                    if (field.isAnnotationPresent(CollectionInitBy.class)) {
                        Class c = field.getAnnotation(CollectionInitBy.class).value();
                        collection = (Collection)c.newInstance();
                    }
                    if (collection == null) {
                        collection = new ArrayList();
                    }
                    JSONArray jsonArray = jsonObject.getJSONArray(fieldName);
                    if (basicType != BasicType.OTHER_TYPE) {
                        collection = this.setCollectionBasicValue(collection, jsonArray, genericType);
                        field.set(t, collection);
                    } else {
                        collection = this.setCollectionCustomValue(collection, jsonArray, genericType);
                        field.set(t, collection);
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof InstantiationException)) break block12;
                throw new RuntimeException(new Exception("@CollectionInitBy must specific a collection implementation subclass "));
            }
        }
    }

    private Collection setCollectionCustomValue(Collection collection, JSONArray jsonArray, Type genericType) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object o = ((Class)genericType).cast(this.generateInstance(genericType));
            o = this.parseEntity(jsonObject, o);
            collection.add(o);
        }
        return collection;
    }

    private Collection setCollectionBasicValue(Collection collection, JSONArray jsonArray, Type genericType) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            collection.add(((Class)genericType).cast(jsonArray.get(i)));
        }
        return collection;
    }

    private <T> void setCustomValue(Field field, JSONObject jsonObject, T t, Type fieldType, String fieldName) throws Exception {
        JSONObject value = jsonObject.getJSONObject(fieldName);
        Object o = this.generateInstance(fieldType);
        o = this.parseEntity(value, o);
        field.set(t, o);
    }

    private <T> void setBasicValue(Field field, JSONObject jsonObject, T t, String fieldName, BasicType basicType) throws Exception {
        Object value = null;
        switch (basicType) {
            case INT: {
                value = jsonObject.getInt(fieldName);
                break;
            }
            case LONG: {
                value = jsonObject.getLong(fieldName);
                break;
            }
            case DOUBLE: {
                value = jsonObject.getDouble(fieldName);
                break;
            }
            case FLOAT: {
                value = Float.valueOf((float)jsonObject.getDouble(fieldName));
                break;
            }
            case BOOLEAN: {
                value = jsonObject.getBoolean(fieldName);
                break;
            }
            case STRING: {
                value = jsonObject.getString(fieldName);
                break;
            }
            default: {
                value = field.getType().cast(jsonObject.get(fieldName));
            }
        }
        field.set(t, value);
    }

    private Object generateInstance(Type type) {
        Class<?> genericsType = null;
        try {
            genericsType = Class.forName(JsonDeer.getClassName(type));
            Object o = genericsType.newInstance();
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getClassName(Type type) {
        String fullName = type.toString();
        if (fullName.startsWith(CLASS_PREFIX)) {
            return fullName.substring(CLASS_PREFIX.length());
        }
        if (fullName.startsWith(INTERFACE_PREFIX)) {
            return fullName.substring(INTERFACE_PREFIX.length());
        }
        return fullName;
    }

    private BasicType isBasicType(Type type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return BasicType.INT;
        }
        if (type == Long.TYPE || type == Long.class) {
            return BasicType.LONG;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BasicType.BOOLEAN;
        }
        if (type == Double.TYPE || type == Double.class) {
            return BasicType.DOUBLE;
        }
        if (type == Float.TYPE || type == Float.class) {
            return BasicType.FLOAT;
        }
        if (type == String.class) {
            return BasicType.STRING;
        }
        return BasicType.OTHER_TYPE;
    }

    private <T> Object parseFieldValue(Field field, T t) throws Exception {
        Type fieldGenericType;
        if (field.isAnnotationPresent(SerializeBy.class)) {
            Class s = field.getAnnotation(SerializeBy.class).value();
            Serializer serializer = (Serializer)s.newInstance();
            return serializer.serialization(field.get(t));
        }
        Class<?> fieldType = field.getType();
        if (fieldType == (fieldGenericType = field.getGenericType())) {
            BasicType basicType = this.isBasicType(fieldType);
            if (basicType != BasicType.OTHER_TYPE) {
                return field.get(t);
            }
            return this.beanToJson(field.get(t));
        }
        ParameterizedType integerListType = (ParameterizedType)fieldGenericType;
        Type genericType = integerListType.getActualTypeArguments()[0];
        BasicType basicType = this.isBasicType(genericType);
        JSONArray jsonArray = new JSONArray();
        if (basicType != BasicType.OTHER_TYPE) {
            List o = (List)field.get(t);
            for (int i = 0; i < o.size(); ++i) {
                jsonArray.put(o.get(i));
            }
        } else {
            List o = (List)field.get(t);
            for (int i = 0; i < o.size(); ++i) {
                jsonArray.put((Object)this.beanToJson(o.get(i)));
            }
        }
        return jsonArray;
    }

    static {
        CLASS_PREFIX = "class ";
        INTERFACE_PREFIX = "interface ";
    }

    private static enum BasicType {
        INT,
        LONG,
        BOOLEAN,
        DOUBLE,
        FLOAT,
        STRING,
        OTHER_TYPE;

    }
}

