/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.andrz.jackson.DefaultObjectMapperFactory;
import me.andrz.jackson.JsonContext;
import me.andrz.jackson.JsonReference;
import me.andrz.jackson.JsonReferenceException;
import me.andrz.jackson.JsonReferenceNode;
import me.andrz.jackson.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReferenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JsonReferenceProcessor.class);
    private int maxDepth = 1;
    private boolean stopOnCircular = true;
    private boolean preserveRefs = false;
    private boolean preserveLocalRefs = false;
    private boolean preserveExternalRefs = false;
    private boolean cacheInMemory = true;
    private String refPrefix = "x-$ref";
    private ObjectMapperFactory mapperFactory;
    private ConcurrentHashMap<Object, JsonNode> cache = new ConcurrentHashMap(1);

    public boolean isCacheInMemory() {
        return this.cacheInMemory;
    }

    public void setCacheInMemory(boolean cacheInMemory) {
        this.cacheInMemory = cacheInMemory;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isStopOnCircular() {
        return this.stopOnCircular;
    }

    public void setStopOnCircular(boolean stopOnCircular) {
        this.stopOnCircular = stopOnCircular;
    }

    public boolean isPreserveRefs() {
        return this.preserveRefs;
    }

    public void setPreserveRefs(boolean preserveRefs) {
        this.preserveRefs = preserveRefs;
    }

    public boolean isPreserveLocalRefs() {
        return this.preserveLocalRefs;
    }

    public void setPreserveLocalRefs(boolean preserveLocalRefs) {
        this.preserveLocalRefs = preserveLocalRefs;
    }

    public boolean isPreserveExternalRefs() {
        return this.preserveExternalRefs;
    }

    public void setPreserveExternalRefs(boolean preserveExternalRefs) {
        this.preserveExternalRefs = preserveExternalRefs;
    }

    public String getRefPrefix() {
        return this.refPrefix;
    }

    public void setRefPrefix(String refPrefix) {
        this.refPrefix = refPrefix;
    }

    public ObjectMapperFactory getMapperFactory() {
        return this.mapperFactory;
    }

    public void setMapperFactory(ObjectMapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    ObjectMapperFactory someMapperFactory() {
        return this.mapperFactory == null ? DefaultObjectMapperFactory.instance : this.mapperFactory;
    }

    public JsonNode process(File file) throws JsonReferenceException, IOException {
        JsonContext context = new JsonContext(file);
        context.setFactory(this.someMapperFactory());
        return this.process(context);
    }

    public JsonNode process(URL url) throws JsonReferenceException, IOException {
        JsonContext context = new JsonContext(url);
        context.setFactory(this.someMapperFactory());
        return this.process(context);
    }

    public JsonNode process(JsonContext context, Set<JsonReference> processed) throws JsonReferenceException, IOException {
        if (context.getFactory() == DefaultObjectMapperFactory.instance) {
            context.setFactory(this.someMapperFactory());
        }
        JsonNode node = context.getNode();
        return this.process(context, node);
    }

    public JsonNode process(JsonContext context) throws JsonReferenceException, IOException {
        return this.process(context, context.getNode());
    }

    public JsonNode process(JsonContext context, JsonNode node) throws JsonReferenceException, IOException {
        block12: {
            block11: {
                if (node == null) {
                    return node;
                }
                if (context.getProcessed() == null) {
                    context.setProcessed(new HashSet<JsonReference>());
                }
                logger.trace("processed: {}", context.getProcessed());
                if (JsonReferenceNode.is(node)) {
                    JsonNode replacementNode = this.getReplacementNode(node, context);
                    logger.debug("replacing whole node with {}", (Object)replacementNode);
                    return replacementNode;
                }
                if (this.maxDepth >= 0 && context.getProcessed() != null && context.getProcessed().size() >= this.maxDepth) {
                    return node;
                }
                if (!node.isArray()) break block11;
                ArrayNode arrayNode = (ArrayNode)node;
                Iterator elements = arrayNode.elements();
                int i = 0;
                while (elements.hasNext()) {
                    JsonNode subNode = (JsonNode)elements.next();
                    logger.trace("i={}", (Object)i);
                    if (JsonReferenceNode.is(subNode)) {
                        JsonNode replacementNode = this.getReplacementNode(subNode, context);
                        if (replacementNode == null) {
                            logger.info("Got null replacement node on position {}", (Object)i);
                            continue;
                        }
                        logger.debug("replacing subNode with {}", (Object)replacementNode);
                        arrayNode.set(i, replacementNode);
                    } else {
                        this.process(context, subNode);
                    }
                    ++i;
                }
                break block12;
            }
            if (!node.isObject()) break block12;
            ObjectNode objectNode = (ObjectNode)node;
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                String key = (String)field.getKey();
                JsonNode subNode = (JsonNode)field.getValue();
                logger.trace("key={}", (Object)key);
                if (JsonReferenceNode.is(subNode)) {
                    JsonNode replacementNode = this.getReplacementNode(subNode, context);
                    if (replacementNode == null) {
                        logger.info("Got null replacement node for key {}", (Object)key);
                        continue;
                    }
                    logger.debug("replacing subNode with {}", (Object)replacementNode);
                    objectNode.set(key, replacementNode);
                    continue;
                }
                this.process(context, subNode);
            }
        }
        return node;
    }

    public JsonNode getReplacementNode(JsonNode node, JsonContext context) throws JsonReferenceException, IOException {
        JsonReferenceNode refNode = JsonReferenceNode.fromNode(node);
        JsonReference ref = refNode.getJsonReference();
        JsonReference absRef = this.getAbsoluteRef(ref, context);
        Set<JsonReference> processed = context.getProcessed();
        if (this.preserveLocalRefs && ref.isLocal() || this.preserveExternalRefs && !ref.isLocal()) {
            return node;
        }
        if (this.stopOnCircular && processed.contains(absRef)) {
            logger.debug("skipping on ref: {}", (Object)absRef);
            return null;
        }
        processed.add(absRef);
        JsonContext referencedContext = this.resolveFromContextToContext(ref, context);
        JsonNode replacementNode = this.process(referencedContext, processed);
        processed.remove(absRef);
        if (this.preserveRefs && replacementNode.isObject()) {
            ((ObjectNode)replacementNode).replace(this.refPrefix, (JsonNode)new TextNode(ref.toString()));
        }
        return replacementNode;
    }

    public JsonReference getAbsoluteRef(JsonReference ref, JsonContext context) throws JsonReferenceException {
        String newRefString = context.getUrl().toString().split("#")[0] + "#" + ref.getPointer().toString();
        JsonReference newRef = JsonReference.fromString(newRefString);
        return newRef;
    }

    public JsonContext resolveFromContextToContext(JsonReference ref, JsonContext context) throws IOException, JsonReferenceException {
        JsonNode referencedNode;
        URL absoluteReferencedUrl;
        URI refUri = ref.getUri();
        logger.debug("dereferencing {}", (Object)ref);
        if (ref.isLocal()) {
            absoluteReferencedUrl = context.getUrl();
            referencedNode = context.at(ref.getPointer());
        } else if (ref.isAbsolute()) {
            absoluteReferencedUrl = refUri.toURL();
            referencedNode = this.read(absoluteReferencedUrl).at(ref.getPointer());
        } else {
            URL contextUrl = context.getUrl();
            try {
                absoluteReferencedUrl = contextUrl.toURI().resolve(refUri).toURL();
            }
            catch (URISyntaxException e) {
                throw new JsonReferenceException("Invalid URI for context URL: " + contextUrl);
            }
            referencedNode = this.read(absoluteReferencedUrl).at(ref.getPointer());
        }
        JsonContext referencedContext = new JsonContext();
        referencedContext.setUrl(absoluteReferencedUrl);
        referencedContext.setNode(referencedNode);
        referencedContext.setFactory(this.someMapperFactory());
        referencedContext.setProcessed(new HashSet<JsonReference>(context.getProcessed()));
        return referencedContext;
    }

    public JsonNode get(JsonReference ref) throws IOException, JsonReferenceException {
        URI refUri = ref.getUri();
        URL url = refUri.toURL();
        JsonNode referencedNode = this.read(url).at(ref.getPointer());
        return referencedNode;
    }

    public JsonNode read(URL url) throws IOException, JsonReferenceException {
        this.putIntoCache(url);
        return this.cache.get(url);
    }

    public JsonNode read(File file) throws IOException, JsonReferenceException {
        this.putIntoCache(file);
        return this.cache.get(file);
    }

    private void putIntoCache(Object any) throws IOException, JsonReferenceException {
        if (any == null) {
            throw new JsonReferenceException("Cannot cache null object.");
        }
        if (this.cacheInMemory && !this.cache.contains(any)) {
            URL url;
            logger.debug("Putting into the cache: {}", any);
            if (any instanceof URL) {
                url = (URL)any;
            } else if (any instanceof File) {
                url = ((File)any).toURI().toURL();
            } else {
                throw new JsonReferenceException("Unknown instance type for cache: " + any.getClass());
            }
            ObjectMapper mapper = this.someMapperFactory().create(url);
            JsonNode tree = mapper.readTree(url);
            if (tree == null) {
                throw new JsonReferenceException("Cannot cache null mapped object.");
            }
            this.cache.putIfAbsent(any, tree);
        }
    }

    public JsonNode readFile(String fileString) throws IOException, JsonReferenceException {
        File file = new File(fileString);
        return this.read(file);
    }
}

