/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import me.andrz.jackson.JsonReference;
import me.andrz.jackson.JsonReferenceException;

public class JsonReferenceNode {
    private JsonNode jsonNode;
    private JsonReference jsonReference;

    private JsonReferenceNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public static JsonReferenceNode fromNode(JsonNode jsonNode) throws JsonReferenceException {
        JsonReference jsonReference;
        JsonReferenceNode jsonReferenceNode = new JsonReferenceNode(jsonNode);
        String refString = JsonReferenceNode.getRefString(jsonNode);
        jsonReferenceNode.jsonReference = jsonReference = JsonReference.fromString(refString);
        return jsonReferenceNode;
    }

    protected static String getRefString(JsonNode jsonNode) throws JsonReferenceException {
        JsonNode $refNode = jsonNode.get("$ref");
        if ($refNode == null) {
            throw new JsonReferenceException("Node does not have \"$ref\" property. node=" + jsonNode);
        }
        if (!$refNode.isTextual()) {
            throw new JsonReferenceException("\"$ref\" value is not textual for node=" + jsonNode);
        }
        String refString = $refNode.textValue();
        return refString;
    }

    public static boolean is(JsonNode node) {
        return node.has("$ref") && node.get("$ref").isTextual();
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public JsonReference getJsonReference() {
        return this.jsonReference;
    }
}

