/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import me.andrz.jackson.DefaultObjectMapperFactory;
import me.andrz.jackson.JsonReference;
import me.andrz.jackson.ObjectMapperFactory;

public class JsonContext {
    JsonNode node;
    URL url;
    ObjectMapperFactory jf;
    private JsonNode document;
    private Set<JsonReference> processed;

    public JsonContext() {
    }

    public JsonContext(File file) throws IOException {
        this(file.toURI().toURL());
    }

    public JsonContext(URL url) {
        this.url = url;
    }

    public JsonNode getDocument() throws IOException {
        ObjectMapper mapper = this.getFactory().create(this.url);
        this.document = mapper.readTree(this.url);
        return this.document;
    }

    public JsonNode getNode() throws IOException {
        if (this.node == null) {
            ObjectMapper mapper = this.getFactory().create(this.url);
            this.node = mapper.readTree(this.url);
        }
        return this.node;
    }

    public void setFactory(ObjectMapperFactory factory) {
        this.jf = factory;
    }

    public ObjectMapperFactory getFactory() {
        return this.jf == null ? DefaultObjectMapperFactory.instance : this.jf;
    }

    public void setNode(JsonNode node) {
        this.node = node;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public Set<JsonReference> getProcessed() {
        return this.processed;
    }

    public void setProcessed(Set<JsonReference> processed) {
        this.processed = processed;
    }

    public JsonNode at(JsonPointer pointer) throws IOException {
        return this.getDocument().at(pointer);
    }
}

