/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import me.andrz.jackson.ObjectMapperFactory;
import me.andrz.jackson.YamlObjectMapperFactory;
import org.apache.commons.io.FilenameUtils;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    public static final DefaultObjectMapperFactory instance = new DefaultObjectMapperFactory();

    private DefaultObjectMapperFactory() {
    }

    @Override
    public ObjectMapper create(URL url) {
        ObjectMapperFactory factory = DefaultObjectMapperFactory.factoryForURL(url);
        if (factory != null) {
            return factory.create(url);
        }
        return new ObjectMapper();
    }

    public static ObjectMapperFactory factoryForURL(URL url) {
        String path = url.getPath();
        String ext = FilenameUtils.getExtension((String)path);
        if ("yml".equals(ext) || "yaml".equals(ext)) {
            return YamlObjectMapperFactory.instance;
        }
        return null;
    }
}

