/*
 * Decompiled with CFR 0.152.
 */
package me.andrz.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import java.net.URI;
import java.net.URISyntaxException;
import me.andrz.jackson.JsonReferenceException;

public class JsonReference {
    private URI uri;
    private JsonPointer pointer;
    private boolean local;
    private boolean absolute;

    public JsonReference() {
    }

    private JsonReference(URI uri) {
        String fragment = uri.getFragment();
        JsonPointer pointer = fragment == null || fragment.isEmpty() ? JsonPointer.compile(null) : JsonPointer.compile((String)fragment);
        uri = uri.normalize();
        this.absolute = uri.isAbsolute();
        this.local = !uri.isAbsolute() && "".equals(uri.getPath());
        this.uri = uri;
        this.pointer = pointer;
    }

    public static JsonReference fromString(String string) throws JsonReferenceException {
        try {
            return JsonReference.fromURI(new URI(string));
        }
        catch (URISyntaxException e) {
            throw new JsonReferenceException("Invalid URI: " + string);
        }
    }

    public static JsonReference fromURI(URI uri) {
        return new JsonReference(uri);
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public URI getUri() {
        return this.uri;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonReference jsonRef = (JsonReference)o;
        return !(this.uri != null ? !this.uri.equals(jsonRef.uri) : jsonRef.uri != null);
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }
}

