/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.simba.SimbaException;
import me.ahoo.simba.jdbc.MutexOwnerEntity;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.jdbc.NotFoundMutexOwnerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/simba/jdbc/JdbcMutexOwnerRepository;", "Lme/ahoo/simba/jdbc/MutexOwnerRepository;", "dataSource", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;)V", "acquire", "", "connection", "Ljava/sql/Connection;", "mutex", "", "contenderId", "ttl", "", "transition", "acquireAndGetOwner", "Lme/ahoo/simba/jdbc/MutexOwnerEntity;", "ensureOwner", "getOwner", "initMutex", "release", "tryInitMutex", "Companion", "simba-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcMutexOwnerRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcMutexOwnerRepository.kt\nme/ahoo/simba/jdbc/JdbcMutexOwnerRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class JdbcMutexOwnerRepository
implements MutexOwnerRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSource dataSource;
    private static final Logger log = LoggerFactory.getLogger(JdbcMutexOwnerRepository.class);
    @NotNull
    private static final String SQL_INIT_MUTEX = "\n                insert into simba_mutex \n                (mutex, acquired_at, ttl_at, transition_at, owner_id, version) \n                values \n                (?, 0, 0, 0, '', 0);\n            ";
    @NotNull
    private static final String SQL_GET = "\n                select acquired_at, ttl_at, transition_at, owner_id, version, cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) as current_at \n                from simba_mutex \n                where mutex = ?;\n            ";
    @NotNull
    private static final String SQL_ACQUIRE = "\n                update simba_mutex \n                set acquired_at=cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned),\n                ttl_at=(cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) + ?),\n                transition_at=(cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) + ?),\n                owner_id= ?,\n                version=version + 1 \n                where mutex = ? \n                and (\n                    (transition_at < (unix_timestamp(current_timestamp(3)) * 1000))\n                    or\n                    (owner_id = ? and transition_at > (unix_timestamp(current_timestamp(3)) * 1000))\n                );\n            ";
    @NotNull
    private static final String SQL_RELEASE = "\n                update simba_mutex \n                set acquired_at=0,\n                ttl_at=0,\n                transition_at=0,\n                owner_id='',\n                version=version + 1 \n                where mutex = ? and owner_id = ?\n            ";

    public JdbcMutexOwnerRepository(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initMutex(@NotNull String mutex) throws SQLException, SQLIntegrityConstraintViolationException {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        if (!(!StringsKt.isBlank((CharSequence)mutex))) {
            boolean bl = false;
            String string = "mutex is blank!";
            throw new IllegalArgumentException(string.toString());
        }
        if (log.isInfoEnabled()) {
            log.info("initMutex - mutex:[{}].", (Object)mutex);
        }
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            boolean bl2 = this.initMutex(connection, mutex);
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean initMutex(Connection connection, String mutex) throws SQLException {
        AutoCloseable autoCloseable = connection.prepareStatement(SQL_INIT_MUTEX);
        Throwable throwable = null;
        try {
            PreparedStatement initStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            initStatement.setString(1, mutex);
            int affected = initStatement.executeUpdate();
            boolean bl2 = affected > 0;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public boolean tryInitMutex(@NotNull String mutex) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        try {
            this.initMutex(mutex);
            bl = true;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info("tryInitMutex failed.[{}]", (Object)throwable.getMessage());
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MutexOwnerEntity getOwner(@NotNull String mutex) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            MutexOwnerEntity mutexOwnerEntity = this.getOwner(connection, mutex);
            return mutexOwnerEntity;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MutexOwnerEntity getOwner(Connection connection, String mutex) throws SQLException {
        AutoCloseable autoCloseable = connection.prepareStatement(SQL_GET);
        Throwable throwable = null;
        try {
            MutexOwnerEntity mutexOwnerEntity;
            PreparedStatement getStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            getStatement.setString(1, mutex);
            AutoCloseable autoCloseable2 = getStatement.executeQuery();
            Throwable throwable2 = null;
            try {
                ResultSet resultSet = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (!resultSet.next()) {
                    throw new NotFoundMutexOwnerException("No mutex:[" + mutex + "] is found, please initialize[MutexOwnerRepository.tryInitMutex] it first.");
                }
                long acquiredAt = resultSet.getLong(1);
                long ttlAt = resultSet.getLong(2);
                long transitionAt = resultSet.getLong(3);
                String ownerId = resultSet.getString(4);
                int version = resultSet.getInt(5);
                long currentAt = resultSet.getLong(6);
                Intrinsics.checkNotNull((Object)ownerId);
                MutexOwnerEntity entity = new MutexOwnerEntity(mutex, ownerId, acquiredAt, ttlAt, transitionAt);
                entity.setVersion(version);
                entity.setCurrentDbAt(currentAt);
                mutexOwnerEntity = entity;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            MutexOwnerEntity mutexOwnerEntity2 = mutexOwnerEntity;
            return mutexOwnerEntity2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MutexOwnerEntity ensureOwner(@NotNull String mutex) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            MutexOwnerEntity mutexOwnerEntity = this.ensureOwner(connection, mutex);
            return mutexOwnerEntity;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final MutexOwnerEntity ensureOwner(Connection connection, String mutex) throws SQLException {
        MutexOwnerEntity mutexOwnerEntity;
        try {
            mutexOwnerEntity = this.getOwner(connection, mutex);
        }
        catch (NotFoundMutexOwnerException notFoundMutexOwnerException) {
            block5: {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("ensureOwner - initMutex:[{}].", (Object)mutex);
                    }
                    this.initMutex(connection, mutex);
                }
                catch (SQLException sqlIntegrityConstraintViolationException) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(sqlIntegrityConstraintViolationException.getMessage(), (Throwable)sqlIntegrityConstraintViolationException);
                }
            }
            mutexOwnerEntity = this.getOwner(connection, mutex);
        }
        return mutexOwnerEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(@NotNull String mutex, @NotNull String contenderId, long ttl, long transition) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        Intrinsics.checkNotNullParameter((Object)contenderId, (String)"contenderId");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection it = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = this.acquire(it, mutex, contenderId, ttl, transition);
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean acquire(Connection connection, String mutex, String contenderId, long ttl, long transition) throws SQLException {
        AutoCloseable autoCloseable = connection.prepareStatement(SQL_ACQUIRE);
        Throwable throwable = null;
        try {
            PreparedStatement acquireStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            acquireStatement.setLong(1, ttl);
            acquireStatement.setLong(2, ttl + transition);
            acquireStatement.setString(3, contenderId);
            acquireStatement.setString(4, mutex);
            acquireStatement.setString(5, contenderId);
            int affected = acquireStatement.executeUpdate();
            boolean bl2 = affected > 0;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MutexOwnerEntity acquireAndGetOwner(@NotNull String mutex, @NotNull String contenderId, long ttl, long transition) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        Intrinsics.checkNotNullParameter((Object)contenderId, (String)"contenderId");
        try {
            AutoCloseable autoCloseable = this.dataSource.getConnection();
            Throwable throwable = null;
            try {
                MutexOwnerEntity mutexOwnerEntity;
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                connection.setAutoCommit(false);
                try {
                    Intrinsics.checkNotNull((Object)connection);
                    boolean acquired = this.acquire(connection, mutex, contenderId, ttl, transition);
                    MutexOwnerEntity mutexOwner = this.ensureOwner(connection, mutex);
                    if (!acquired && !mutexOwner.hasOwner()) {
                        if (log.isInfoEnabled()) {
                            log.info("acquireAndGetOwner - There is no competition for leadership && There is currently no leader [When initializing]. Retry!");
                        }
                        acquired = this.acquire(connection, mutex, contenderId, ttl, transition);
                        mutexOwner = this.ensureOwner(connection, mutex);
                    }
                    if (!(!acquired || mutexOwner.isOwner(contenderId))) {
                        boolean bl2 = false;
                        String string = "Contender:[" + contenderId + "] has acquired leadership, but MutexOwner status is inconsistent!";
                        throw new IllegalStateException(string.toString());
                    }
                    connection.commit();
                    mutexOwnerEntity = mutexOwner;
                }
                catch (Throwable throwable2) {
                    connection.rollback();
                    String string = throwable2.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    throw new SimbaException(string, throwable2);
                }
                MutexOwnerEntity mutexOwnerEntity2 = mutexOwnerEntity;
                return mutexOwnerEntity2;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException sqlException) {
            String string = sqlException.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new SimbaException(string, (Throwable)sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(@NotNull String mutex, @NotNull String contenderId) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        Intrinsics.checkNotNullParameter((Object)contenderId, (String)"contenderId");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection connection = (Connection)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(SQL_RELEASE);
            Throwable throwable2 = null;
            try {
                PreparedStatement initStatement = (PreparedStatement)autoCloseable2;
                boolean bl3 = false;
                initStatement.setString(1, mutex);
                initStatement.setString(2, contenderId);
                int affected = initStatement.executeUpdate();
                bl = affected > 0;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/simba/jdbc/JdbcMutexOwnerRepository$Companion;", "", "()V", "SQL_ACQUIRE", "", "SQL_GET", "SQL_INIT_MUTEX", "SQL_RELEASE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "simba-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

