/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.schedule;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.AbstractMutexContender;
import me.ahoo.simba.core.MutexContendService;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.core.MutexState;
import me.ahoo.simba.schedule.ScheduleConfig;
import me.ahoo.simba.util.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0016H$R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lme/ahoo/simba/schedule/AbstractScheduler;", "", "mutex", "", "contendServiceFactory", "Lme/ahoo/simba/core/MutexContendServiceFactory;", "(Ljava/lang/String;Lme/ahoo/simba/core/MutexContendServiceFactory;)V", "config", "Lme/ahoo/simba/schedule/ScheduleConfig;", "getConfig", "()Lme/ahoo/simba/schedule/ScheduleConfig;", "contendService", "Lme/ahoo/simba/core/MutexContendService;", "getMutex", "()Ljava/lang/String;", "running", "", "getRunning", "()Z", "worker", "getWorker", "start", "", "stop", "work", "Companion", "WorkContender", "simba-core"})
public abstract class AbstractScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mutex;
    @NotNull
    private final MutexContendService contendService;
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduler.class);

    public AbstractScheduler(@NotNull String mutex, @NotNull MutexContendServiceFactory contendServiceFactory) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        Intrinsics.checkNotNullParameter((Object)contendServiceFactory, (String)"contendServiceFactory");
        this.mutex = mutex;
        this.contendService = contendServiceFactory.createMutexContendService(new WorkContender(this.mutex));
    }

    @NotNull
    public final String getMutex() {
        return this.mutex;
    }

    @NotNull
    protected abstract ScheduleConfig getConfig();

    @NotNull
    protected abstract String getWorker();

    protected abstract void work();

    public final void start() {
        this.contendService.start();
    }

    public final void stop() {
        this.contendService.stop();
    }

    public final boolean getRunning() {
        return this.contendService.getRunning();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/simba/schedule/AbstractScheduler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "simba-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/simba/schedule/AbstractScheduler$WorkContender;", "Lme/ahoo/simba/core/AbstractMutexContender;", "mutex", "", "(Lme/ahoo/simba/schedule/AbstractScheduler;Ljava/lang/String;)V", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "workFuture", "Ljava/util/concurrent/ScheduledFuture;", "onAcquired", "", "mutexState", "Lme/ahoo/simba/core/MutexState;", "onReleased", "safeWork", "simba-core"})
    public final class WorkContender
    extends AbstractMutexContender {
        @NotNull
        private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        @Nullable
        private volatile ScheduledFuture<?> workFuture;

        public WorkContender(String mutex) {
            Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
            super(mutex, null, 2, null);
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, Threads.defaultFactory(AbstractScheduler.this.getWorker()));
        }

        @Override
        public void onAcquired(@NotNull MutexState mutexState) {
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                    super.onAcquired(mutexState);
                    if (this.workFuture == null) break block2;
                    ScheduledFuture<?> scheduledFuture = this.workFuture;
                    Intrinsics.checkNotNull(scheduledFuture);
                    if (!scheduledFuture.isDone()) break block3;
                }
                long initialDelay = AbstractScheduler.this.getConfig().getInitialDelay().toMillis();
                long period = AbstractScheduler.this.getConfig().getPeriod().toMillis();
                this.workFuture = ScheduleConfig.Strategy.FIXED_RATE == AbstractScheduler.this.getConfig().getStrategy() ? this.scheduledThreadPoolExecutor.scheduleAtFixedRate(this::safeWork, initialDelay, period, TimeUnit.MILLISECONDS) : this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(this::safeWork, initialDelay, period, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void onReleased(@NotNull MutexState mutexState) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                super.onReleased(mutexState);
                ScheduledFuture<?> scheduledFuture = this.workFuture;
                if (scheduledFuture == null) break block0;
                scheduledFuture.cancel(true);
            }
        }

        private final void safeWork() {
            block2: {
                try {
                    AbstractScheduler.this.work();
                }
                catch (Throwable throwable) {
                    if (!log.isErrorEnabled()) break block2;
                    log.error(throwable.getMessage(), throwable);
                }
            }
        }
    }
}

