/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.core.MutexRetrievalService;
import me.ahoo.simba.core.MutexRetriever;
import me.ahoo.simba.core.MutexState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u0010\u001f\u001a\u00020\u0019H\u0004J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u0010!\u001a\u00020\u0019H\u0016J\b\u0010\"\u001a\u00020\u0019H$J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0019H$R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0012@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lme/ahoo/simba/core/AbstractMutexRetrievalService;", "Lme/ahoo/simba/core/MutexRetrievalService;", "retriever", "Lme/ahoo/simba/core/MutexRetriever;", "handleExecutor", "Ljava/util/concurrent/Executor;", "(Lme/ahoo/simba/core/MutexRetriever;Ljava/util/concurrent/Executor;)V", "getHandleExecutor", "()Ljava/util/concurrent/Executor;", "<set-?>", "Lme/ahoo/simba/core/MutexState;", "mutexState", "getMutexState", "()Lme/ahoo/simba/core/MutexState;", "setMutexState", "(Lme/ahoo/simba/core/MutexState;)V", "getRetriever", "()Lme/ahoo/simba/core/MutexRetriever;", "", "running", "getRunning", "()Z", "setRunning", "(Z)V", "close", "", "notifyOwner", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "newOwner", "Lme/ahoo/simba/core/MutexOwner;", "resetOwner", "safeNotifyOwner", "start", "startRetrieval", "stop", "stopRetrieval", "Companion", "simba-core"})
public abstract class AbstractMutexRetrievalService
implements MutexRetrievalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutexRetriever retriever;
    @NotNull
    private final Executor handleExecutor;
    private volatile boolean running;
    @NotNull
    private volatile MutexState mutexState;
    private static final Logger log = LoggerFactory.getLogger(AbstractMutexRetrievalService.class);

    protected AbstractMutexRetrievalService(@NotNull MutexRetriever retriever, @NotNull Executor handleExecutor) {
        Intrinsics.checkNotNullParameter((Object)retriever, (String)"retriever");
        Intrinsics.checkNotNullParameter((Object)handleExecutor, (String)"handleExecutor");
        this.retriever = retriever;
        this.handleExecutor = handleExecutor;
        this.mutexState = MutexState.Companion.getNONE();
    }

    @Override
    @NotNull
    public MutexRetriever getRetriever() {
        return this.retriever;
    }

    @NotNull
    protected final Executor getHandleExecutor() {
        return this.handleExecutor;
    }

    @Override
    public boolean getRunning() {
        return this.running;
    }

    protected void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    @NotNull
    public MutexState getMutexState() {
        return this.mutexState;
    }

    protected void setMutexState(@NotNull MutexState mutexState) {
        Intrinsics.checkNotNullParameter((Object)mutexState, (String)"<set-?>");
        this.mutexState = mutexState;
    }

    protected final void resetOwner() {
        this.setMutexState(MutexState.Companion.getNONE());
    }

    @Override
    public synchronized void start() {
        if (log.isInfoEnabled()) {
            log.info("start - mutex:[{}] - running:[{}]", (Object)this.getRetriever().getMutex(), (Object)this.getRunning());
        }
        if (this.getRunning()) {
            return;
        }
        this.setRunning(true);
        this.startRetrieval();
    }

    protected abstract void startRetrieval();

    protected abstract void stopRetrieval();

    @NotNull
    protected final CompletableFuture<Void> notifyOwner(@NotNull MutexOwner newOwner) {
        Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> AbstractMutexRetrievalService.notifyOwner$lambda$0(this, newOwner), this.handleExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    protected final void safeNotifyOwner(@NotNull MutexOwner newOwner) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
            try {
                MutexState newState = new MutexState(this.getAfterOwner(), newOwner);
                this.setMutexState(newState);
                this.getRetriever().notifyOwner(newState);
            }
            catch (Throwable throwable) {
                if (!log.isErrorEnabled()) break block2;
                log.error(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (log.isInfoEnabled()) {
            log.info("stop - mutex:[{}] - running:[{}]", (Object)this.getRetriever().getMutex(), (Object)this.getRunning());
        }
        if (!this.getRunning()) {
            return;
        }
        this.setRunning(false);
        this.stopRetrieval();
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private static final void notifyOwner$lambda$0(AbstractMutexRetrievalService this$0, MutexOwner $newOwner) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newOwner, (String)"$newOwner");
        this$0.safeNotifyOwner($newOwner);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/simba/core/AbstractMutexRetrievalService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "simba-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

