/*
 * Decompiled with CFR 0.152.
 */
package me.aflak.libraries.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import me.aflak.libraries.R;
import me.aflak.libraries.callback.FailAuthCounterCallback;
import me.aflak.libraries.callback.FingerprintCallback;
import me.aflak.libraries.callback.FingerprintSecureCallback;
import me.aflak.libraries.utils.CipherHelper;
import me.aflak.libraries.utils.FingerprintToken;

public class Fingerprint
extends RelativeLayout {
    private static final String TAG = "FingerprintView";
    private View fingerprintImageView;
    private View circleView;
    private FingerprintManager fingerprintManager;
    private CancellationSignal cancellationSignal;
    private FingerprintCallback fingerprintCallback;
    private FingerprintSecureCallback fingerprintSecureCallback;
    private FailAuthCounterCallback counterCallback;
    private FingerprintManager.CryptoObject cryptoObject;
    private CipherHelper cipherHelper;
    private Handler handler;
    private int fingerprintScanning;
    private int fingerprintSuccess;
    private int fingerprintError;
    private int circleScanning;
    private int circleSuccess;
    private int circleError;
    private int limit;
    private int tryCounter;
    private int delayAfterError;
    private int size;
    public static final int DEFAULT_DELAY_AFTER_ERROR = 1200;
    public static final int DEFAULT_CIRCLE_SIZE = 50;
    public static final int DEFAULT_FINGERPRINT_SIZE = 30;
    public static final float SCALE = 0.6f;
    private Runnable returnToScanning = new Runnable(){

        @Override
        public void run() {
            Fingerprint.this.setStatus(R.drawable.fingerprint, Fingerprint.this.fingerprintScanning, Fingerprint.this.circleScanning);
        }
    };

    public Fingerprint(Context context) {
        super(context);
    }

    public Fingerprint(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs, 0, 0);
        this.initView(context);
    }

    public Fingerprint(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs, defStyleAttr, 0);
        this.initView(context);
    }

    public Fingerprint(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ResourceType"})
    private void initAttributes(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Fingerprint, defStyleAttr, defStyleRes);
        try {
            this.fingerprintScanning = a.getResourceId(R.styleable.Fingerprint_fingerprintScanningColor, R.color.fingerprint_scanning);
            this.fingerprintSuccess = a.getResourceId(R.styleable.Fingerprint_fingerprintSuccessColor, R.color.fingerprint_success);
            this.fingerprintError = a.getResourceId(R.styleable.Fingerprint_fingerprintErrorColor, R.color.fingerprint_error);
            this.circleScanning = a.getResourceId(R.styleable.Fingerprint_circleScanningColor, R.color.circle_scanning);
            this.circleSuccess = a.getResourceId(R.styleable.Fingerprint_circleSuccessColor, R.color.circle_success);
            this.circleError = a.getResourceId(R.styleable.Fingerprint_circleErrorColor, R.color.circle_error);
        }
        finally {
            a.recycle();
        }
        int[] systemAttrs = new int[]{16842996, 16842997};
        TypedArray ta = context.obtainStyledAttributes(attrs, systemAttrs);
        try {
            int width = ta.getLayoutDimension(0, -2);
            int height = ta.getLayoutDimension(1, -2);
            this.size = width == -2 || height == -2 ? this.dipToPixels(50) : width;
        }
        finally {
            ta.recycle();
        }
    }

    private void initView(Context context) {
        this.fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
        this.cipherHelper = null;
        this.handler = new Handler();
        this.fingerprintCallback = null;
        this.fingerprintSecureCallback = null;
        this.counterCallback = null;
        this.cryptoObject = null;
        this.tryCounter = 0;
        this.delayAfterError = 1200;
        int fingerprintSize = (int)((float)this.size * 0.6f);
        int circleSize = this.size;
        this.fingerprintImageView = new AppCompatImageView(context);
        this.fingerprintImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(fingerprintSize, fingerprintSize));
        this.fingerprintImageView.setBackgroundResource(R.drawable.fingerprint);
        ((RelativeLayout.LayoutParams)this.fingerprintImageView.getLayoutParams()).addRule(13, -1);
        this.circleView = new View(context);
        this.circleView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(circleSize, circleSize));
        this.circleView.setBackgroundResource(R.drawable.circle);
        ((RelativeLayout.LayoutParams)this.circleView.getLayoutParams()).addRule(13, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.addView(this.circleView);
        this.addView(this.fingerprintImageView);
        this.setStatus(R.drawable.fingerprint, this.fingerprintScanning, this.circleScanning);
    }

    private int dipToPixels(int dipValue) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)metrics);
    }

    private void setStatus(int drawableId, int drawableColorId, int circleColorId) {
        Context context = this.getContext();
        this.fingerprintImageView.setBackgroundResource(drawableId);
        this.fingerprintImageView.setBackgroundTintList(ColorStateList.valueOf((int)context.getColor(drawableColorId)));
        this.circleView.setBackgroundTintList(ColorStateList.valueOf((int)context.getColor(circleColorId)));
    }

    public Fingerprint callback(FingerprintCallback fingerprintCallback) {
        this.fingerprintCallback = fingerprintCallback;
        return this;
    }

    public Fingerprint callback(FingerprintSecureCallback fingerprintSecureCallback, String KEY_NAME) {
        this.fingerprintSecureCallback = fingerprintSecureCallback;
        this.cipherHelper = new CipherHelper(KEY_NAME);
        return this;
    }

    public Fingerprint cryptoObject(FingerprintManager.CryptoObject cryptoObject) {
        this.cryptoObject = cryptoObject;
        return this;
    }

    public Fingerprint fingerprintScanningColor(int fingerprintScanning) {
        this.fingerprintScanning = fingerprintScanning;
        this.fingerprintImageView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(fingerprintScanning)));
        return this;
    }

    public Fingerprint fingerprintSuccessColor(int fingerprintSuccess) {
        this.fingerprintSuccess = fingerprintSuccess;
        this.fingerprintImageView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(fingerprintSuccess)));
        return this;
    }

    public Fingerprint fingerprintErrorColor(int fingerprintError) {
        this.fingerprintError = fingerprintError;
        this.fingerprintImageView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(fingerprintError)));
        return this;
    }

    public Fingerprint circleScanningColor(int circleScanning) {
        this.circleScanning = circleScanning;
        this.circleView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(circleScanning)));
        return this;
    }

    public Fingerprint circleSuccessColor(int circleSuccess) {
        this.circleSuccess = circleSuccess;
        this.circleView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(circleSuccess)));
        return this;
    }

    public Fingerprint circleErrorColor(int circleError) {
        this.circleError = circleError;
        this.circleView.setBackgroundTintList(ColorStateList.valueOf((int)this.getContext().getColor(circleError)));
        return this;
    }

    public Fingerprint tryLimit(int limit, FailAuthCounterCallback counterCallback) {
        this.limit = limit;
        this.counterCallback = counterCallback;
        return this;
    }

    public Fingerprint delayAfterError(int delayAfterError) {
        this.delayAfterError = delayAfterError;
        return this;
    }

    public static boolean isAvailable(Context context) {
        FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
        if (fingerprintManager != null) {
            return fingerprintManager.isHardwareDetected() && fingerprintManager.hasEnrolledFingerprints();
        }
        return false;
    }

    public void authenticate() {
        if (this.fingerprintSecureCallback != null) {
            if (this.cryptoObject != null) {
                throw new RuntimeException("If you specify a CryptoObject you have to use FingerprintCallback");
            }
            this.cryptoObject = this.cipherHelper.getEncryptionCryptoObject();
            if (this.cryptoObject == null) {
                this.fingerprintSecureCallback.onNewFingerprintEnrolled(new FingerprintToken(this.cipherHelper));
            }
        } else if (this.fingerprintCallback == null) {
            throw new RuntimeException("You must specify a callback.");
        }
        this.cancellationSignal = new CancellationSignal();
        if (this.fingerprintManager.isHardwareDetected() && this.fingerprintManager.hasEnrolledFingerprints()) {
            this.fingerprintManager.authenticate(this.cryptoObject, this.cancellationSignal, 0, new FingerprintManager.AuthenticationCallback(){

                public void onAuthenticationError(int errorCode, CharSequence errString) {
                    super.onAuthenticationError(errorCode, errString);
                    Fingerprint.this.setStatus(R.drawable.fingerprint_error, Fingerprint.this.fingerprintError, Fingerprint.this.circleError);
                    Fingerprint.this.handler.postDelayed(Fingerprint.this.returnToScanning, (long)Fingerprint.this.delayAfterError);
                    if (Fingerprint.this.fingerprintSecureCallback != null) {
                        Fingerprint.this.fingerprintSecureCallback.onAuthenticationError(errorCode, errString.toString());
                    } else {
                        Fingerprint.this.fingerprintCallback.onAuthenticationError(errorCode, errString.toString());
                    }
                }

                public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
                    super.onAuthenticationHelp(helpCode, helpString);
                    Fingerprint.this.setStatus(R.drawable.fingerprint_error, Fingerprint.this.fingerprintError, Fingerprint.this.circleError);
                    Fingerprint.this.handler.postDelayed(Fingerprint.this.returnToScanning, (long)Fingerprint.this.delayAfterError);
                    if (Fingerprint.this.fingerprintSecureCallback != null) {
                        Fingerprint.this.fingerprintSecureCallback.onAuthenticationError(helpCode, helpString.toString());
                    } else {
                        Fingerprint.this.fingerprintCallback.onAuthenticationError(helpCode, helpString.toString());
                    }
                }

                public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                    super.onAuthenticationSucceeded(result);
                    Fingerprint.this.handler.removeCallbacks(Fingerprint.this.returnToScanning);
                    Fingerprint.this.setStatus(R.drawable.fingerprint_success, Fingerprint.this.fingerprintSuccess, Fingerprint.this.circleSuccess);
                    if (Fingerprint.this.fingerprintSecureCallback != null) {
                        Fingerprint.this.fingerprintSecureCallback.onAuthenticationSucceeded();
                    } else {
                        Fingerprint.this.fingerprintCallback.onAuthenticationSucceeded();
                    }
                    Fingerprint.this.tryCounter = 0;
                }

                public void onAuthenticationFailed() {
                    super.onAuthenticationFailed();
                    Fingerprint.this.setStatus(R.drawable.fingerprint_error, Fingerprint.this.fingerprintError, Fingerprint.this.circleError);
                    Fingerprint.this.handler.postDelayed(Fingerprint.this.returnToScanning, (long)Fingerprint.this.delayAfterError);
                    if (Fingerprint.this.fingerprintSecureCallback != null) {
                        Fingerprint.this.fingerprintSecureCallback.onAuthenticationFailed();
                    } else {
                        Fingerprint.this.fingerprintCallback.onAuthenticationFailed();
                    }
                    if (Fingerprint.this.counterCallback != null && ++Fingerprint.this.tryCounter == Fingerprint.this.limit) {
                        Fingerprint.this.counterCallback.onTryLimitReached();
                    }
                }
            }, null);
        } else {
            Log.e((String)TAG, (String)"Fingerprint scanner not detected or no fingerprint enrolled. Use FingerprintView#isAvailable(Context) before.");
        }
    }

    public void cancel() {
        this.cancellationSignal.cancel();
        this.returnToScanning.run();
    }
}

