/*
 * Decompiled with CFR 0.152.
 */
package me.aflak.libraries.utils;

import android.hardware.fingerprint.FingerprintManager;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class CipherHelper {
    private KeyStore keyStore;
    private Cipher cipher;
    private SecretKey cipherKey;
    private KeyGenerator cipherKeyGenerator;
    private boolean keyStoreLoaded;
    private boolean cipherKeyGenCreated;
    private boolean cipherCreated;
    private final String keyName;
    private final String provider = "AndroidKeyStore";

    public CipherHelper(String keyName) {
        this.keyName = keyName;
        this.keyStoreLoaded = false;
        this.cipherKeyGenCreated = false;
        this.cipherCreated = false;
    }

    private void loadKeyStore() {
        if (this.keyStoreLoaded) {
            return;
        }
        this.reloadKeyStore();
    }

    private void reloadKeyStore() {
        try {
            this.keyStore = KeyStore.getInstance("AndroidKeyStore");
            this.keyStore.load(null);
            this.keyStoreLoaded = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get keystore", e);
        }
    }

    private boolean hasKey() {
        try {
            this.cipherKey = (SecretKey)this.keyStore.getKey(this.keyName, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Failed to get key", e);
        }
        return this.cipherKey != null;
    }

    private void createCipherKeyGenerator() {
        if (this.cipherKeyGenCreated) {
            return;
        }
        try {
            this.cipherKeyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            this.cipherKeyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(this.keyName, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build());
            this.cipherKeyGenCreated = true;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("Failed to create key generator", e);
        }
    }

    private void createCipher() {
        if (this.cipherCreated) {
            return;
        }
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            this.cipherCreated = true;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Failed to get an instance of Cipher", e);
        }
    }

    private boolean initEncryptionCipher() {
        try {
            this.cipher.init(1, this.cipherKey);
            return true;
        }
        catch (KeyPermanentlyInvalidatedException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to init Cipher", e);
        }
    }

    private boolean initDecryptionCipher(byte[] ivBytes) {
        try {
            this.cipher.init(2, (Key)this.cipherKey, new IvParameterSpec(ivBytes));
            return true;
        }
        catch (KeyPermanentlyInvalidatedException e) {
            return false;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new RuntimeException("Failed to init Cipher", e);
        }
    }

    public void generateNewKey() {
        this.createCipherKeyGenerator();
        this.cipherKey = this.cipherKeyGenerator.generateKey();
        this.reloadKeyStore();
    }

    public FingerprintManager.CryptoObject getEncryptionCryptoObject() {
        this.loadKeyStore();
        if (!this.hasKey()) {
            this.generateNewKey();
        }
        this.createCipher();
        if (this.initEncryptionCipher()) {
            return new FingerprintManager.CryptoObject(this.cipher);
        }
        return null;
    }

    public FingerprintManager.CryptoObject getDecryptionCryptoObject(byte[] ivBytes) {
        this.loadKeyStore();
        if (!this.hasKey()) {
            this.generateNewKey();
        }
        this.createCipher();
        if (this.initDecryptionCipher(ivBytes)) {
            return new FingerprintManager.CryptoObject(this.cipher);
        }
        return null;
    }
}

