/*
 * Decompiled with CFR 0.152.
 */
package me.aflak.libraries.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import me.aflak.libraries.R;
import me.aflak.libraries.callback.FailAuthCounterCallback;
import me.aflak.libraries.callback.PasswordCallback;
import me.aflak.libraries.dialog.AnimatedDialog;
import me.aflak.libraries.dialog.DialogAnimation;
import me.aflak.libraries.utils.FingerprintToken;

public class PasswordDialog
extends AnimatedDialog<PasswordDialog> {
    private FingerprintToken token;
    private PasswordCallback callback;
    private FailAuthCounterCallback counterCallback;
    private int passwordType;
    private int limit;
    private int tryCounter;
    public static final int PASSWORD_TYPE_TEXT = 129;
    public static final int PASSWORD_TYPE_NUMBER = 18;
    private static final String TAG = "PasswordDialog";

    private PasswordDialog(Context context, FingerprintToken token) {
        super(context);
        this.token = token;
        this.passwordType = 129;
        this.callback = null;
        this.counterCallback = null;
        this.tryCounter = 0;
    }

    public static PasswordDialog initialize(Context context, FingerprintToken token) {
        return new PasswordDialog(context, token);
    }

    public static PasswordDialog initialize(Context context) {
        return new PasswordDialog(context, null);
    }

    public PasswordDialog callback(PasswordCallback callback) {
        this.callback = callback;
        return this;
    }

    public PasswordDialog tryLimit(int limit, FailAuthCounterCallback counterCallback) {
        this.limit = limit;
        this.counterCallback = counterCallback;
        return this;
    }

    public PasswordDialog passwordType(int passwordType) {
        this.passwordType = passwordType;
        return this;
    }

    public void show() {
        if (this.title == null || this.message == null) {
            throw new RuntimeException("Title or message cannot be null.");
        }
        this.dialogView = this.layoutInflater.inflate(R.layout.password_dialog, null);
        ((TextView)this.dialogView.findViewById(R.id.password_dialog_title)).setText((CharSequence)this.title);
        ((TextView)this.dialogView.findViewById(R.id.password_dialog_message)).setText((CharSequence)this.message);
        final EditText input = (EditText)this.dialogView.findViewById(R.id.password_dialog_input);
        input.setInputType(this.passwordType);
        this.dialog = this.builder.setView(this.dialogView).setPositiveButton(R.string.password_confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).setNegativeButton(R.string.password_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (PasswordDialog.this.callback != null) {
                    PasswordDialog.this.callback.onPasswordCancel();
                }
            }
        }).create();
        if (this.dialog.getWindow() != null) {
            if (this.enterAnimation != DialogAnimation.Enter.APPEAR || this.exitAnimation != DialogAnimation.Exit.DISAPPEAR) {
                int style2 = DialogAnimation.getStyle(this.enterAnimation, this.exitAnimation);
                if (style2 != -1) {
                    this.dialog.getWindow().getAttributes().windowAnimations = style2;
                } else {
                    Log.w((String)TAG, (String)"The animation selected is not available. Default animation will be used.");
                }
            }
            if (!this.dimBackground) {
                this.dialog.getWindow().clearFlags(2);
            }
        } else {
            Log.w((String)TAG, (String)"Could not get window from dialog");
        }
        this.dialog.setCanceledOnTouchOutside(this.cancelOnTouchOutside);
        this.dialog.setCancelable(this.cancelOnPressBack);
        this.dialog.show();
        this.dialog.getButton(-1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PasswordDialog.this.callback != null) {
                    String password = input.getText().toString();
                    if (PasswordDialog.this.callback.onPasswordCheck(password)) {
                        PasswordDialog.this.dialog.dismiss();
                        if (PasswordDialog.this.token != null) {
                            PasswordDialog.this.token.validate();
                        }
                        PasswordDialog.this.tryCounter = 0;
                        PasswordDialog.this.callback.onPasswordSucceeded();
                    } else {
                        input.setText((CharSequence)"");
                        input.setError((CharSequence)PasswordDialog.this.context.getResources().getString(R.string.password_incorrect));
                        PasswordDialog.this.tryCounter++;
                        if (PasswordDialog.this.counterCallback != null && PasswordDialog.this.tryCounter == PasswordDialog.this.limit) {
                            PasswordDialog.this.counterCallback.onTryLimitReached();
                        }
                    }
                }
            }
        });
    }
}

