/*
 * Decompiled with CFR 0.152.
 */
package me.aflak.libraries.dialog;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Handler;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.AppCompatButton;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import me.aflak.libraries.R;
import me.aflak.libraries.callback.FailAuthCounterCallback;
import me.aflak.libraries.callback.FingerprintCallback;
import me.aflak.libraries.callback.FingerprintDialogCallback;
import me.aflak.libraries.callback.FingerprintDialogSecureCallback;
import me.aflak.libraries.callback.FingerprintSecureCallback;
import me.aflak.libraries.dialog.AnimatedDialog;
import me.aflak.libraries.dialog.DialogAnimation;
import me.aflak.libraries.utils.FingerprintToken;
import me.aflak.libraries.view.Fingerprint;

public class FingerprintDialog
extends AnimatedDialog<FingerprintDialog> {
    private Fingerprint fingerprint;
    private TextView dialogTitle;
    private TextView dialogMessage;
    private TextView dialogStatus;
    private AppCompatButton cancelButton;
    private AppCompatButton usePasswordButton;
    private FingerprintDialogCallback fingerprintDialogCallback;
    private FingerprintDialogSecureCallback fingerprintDialogSecureCallback;
    private int statusScanningColor;
    private int statusSuccessColor;
    private int statusErrorColor;
    private View.OnClickListener onUsePassword;
    private Handler handler;
    private int delayAfterError;
    private int delayAfterSuccess;
    private static final String TAG = "FingerprintDialog";
    private Runnable returnToScanning = new Runnable(){

        @Override
        public void run() {
            FingerprintDialog.this.setStatus(R.string.fingerprint_state_scanning, FingerprintDialog.this.statusScanningColor);
        }
    };
    private FingerprintCallback fingerprintCallback = new FingerprintCallback(){

        @Override
        public void onAuthenticationSucceeded() {
            FingerprintDialog.this.handler.removeCallbacks(FingerprintDialog.this.returnToScanning);
            FingerprintDialog.this.setStatus(R.string.fingerprint_state_success, FingerprintDialog.this.statusSuccessColor);
            FingerprintDialog.this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FingerprintDialog.this.dialog.cancel();
                    if (FingerprintDialog.this.fingerprintDialogCallback != null) {
                        FingerprintDialog.this.fingerprintDialogCallback.onAuthenticationSucceeded();
                    }
                }
            }, (long)FingerprintDialog.this.delayAfterSuccess);
        }

        @Override
        public void onAuthenticationFailed() {
            FingerprintDialog.this.setStatus(R.string.fingerprint_state_failure, FingerprintDialog.this.statusErrorColor);
            FingerprintDialog.this.handler.postDelayed(FingerprintDialog.this.returnToScanning, (long)FingerprintDialog.this.delayAfterError);
        }

        @Override
        public void onAuthenticationError(int errorCode, String error) {
            FingerprintDialog.this.setStatus(error, FingerprintDialog.this.statusErrorColor);
            FingerprintDialog.this.handler.postDelayed(FingerprintDialog.this.returnToScanning, (long)FingerprintDialog.this.delayAfterError);
        }
    };
    private FingerprintSecureCallback fingerprintSecureCallback = new FingerprintSecureCallback(){

        @Override
        public void onAuthenticationSucceeded() {
            FingerprintDialog.this.handler.removeCallbacks(FingerprintDialog.this.returnToScanning);
            FingerprintDialog.this.setStatus(R.string.fingerprint_state_success, FingerprintDialog.this.statusSuccessColor);
            FingerprintDialog.this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FingerprintDialog.this.dialog.cancel();
                    if (FingerprintDialog.this.fingerprintDialogSecureCallback != null) {
                        FingerprintDialog.this.fingerprintDialogSecureCallback.onAuthenticationSucceeded();
                    }
                }
            }, (long)FingerprintDialog.this.delayAfterSuccess);
        }

        @Override
        public void onAuthenticationFailed() {
            FingerprintDialog.this.setStatus(R.string.fingerprint_state_failure, FingerprintDialog.this.statusErrorColor);
            FingerprintDialog.this.handler.postDelayed(FingerprintDialog.this.returnToScanning, (long)FingerprintDialog.this.delayAfterError);
        }

        @Override
        public void onNewFingerprintEnrolled(FingerprintToken token) {
            FingerprintDialog.this.dialog.cancel();
            if (FingerprintDialog.this.fingerprintDialogSecureCallback != null) {
                FingerprintDialog.this.fingerprintDialogSecureCallback.onNewFingerprintEnrolled(token);
            }
        }

        @Override
        public void onAuthenticationError(int errorCode, String error) {
            FingerprintDialog.this.setStatus(error, FingerprintDialog.this.statusErrorColor);
            FingerprintDialog.this.handler.postDelayed(FingerprintDialog.this.returnToScanning, (long)FingerprintDialog.this.delayAfterError);
        }
    };

    private FingerprintDialog(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.handler = new Handler();
        this.onUsePassword = null;
        this.delayAfterError = 1200;
        this.delayAfterSuccess = 1200;
        this.statusScanningColor = R.color.status_scanning;
        this.statusSuccessColor = R.color.status_success;
        this.statusErrorColor = R.color.status_error;
        this.dialogView = this.layoutInflater.inflate(R.layout.fingerprint_dialog, null);
        this.fingerprint = (Fingerprint)this.dialogView.findViewById(R.id.fingerprint_dialog_fp);
        this.dialogTitle = (TextView)this.dialogView.findViewById(R.id.fingerprint_dialog_title);
        this.dialogMessage = (TextView)this.dialogView.findViewById(R.id.fingerprint_dialog_message);
        this.dialogStatus = (TextView)this.dialogView.findViewById(R.id.fingerprint_dialog_status);
        this.cancelButton = (AppCompatButton)this.dialogView.findViewById(R.id.fingerprint_dialog_cancel);
        this.usePasswordButton = (AppCompatButton)this.dialogView.findViewById(R.id.fingerprint_dialog_use_password);
    }

    public static boolean isAvailable(Context context) {
        FingerprintManager manager = (FingerprintManager)context.getSystemService("fingerprint");
        return manager != null && manager.isHardwareDetected() && manager.hasEnrolledFingerprints();
    }

    public static FingerprintDialog initialize(Context context) {
        return new FingerprintDialog(context);
    }

    public FingerprintDialog callback(FingerprintDialogCallback fingerprintDialogCallback) {
        this.fingerprintDialogCallback = fingerprintDialogCallback;
        this.fingerprint.callback(this.fingerprintCallback);
        return this;
    }

    public FingerprintDialog callback(FingerprintDialogSecureCallback fingerprintDialogSecureCallback, String KEY_NAME) {
        this.fingerprintDialogSecureCallback = fingerprintDialogSecureCallback;
        this.fingerprint.callback(this.fingerprintSecureCallback, KEY_NAME);
        return this;
    }

    public FingerprintDialog cryptoObject(FingerprintManager.CryptoObject cryptoObject) {
        this.fingerprint.cryptoObject(cryptoObject);
        return this;
    }

    public FingerprintDialog fingerprintScanningColor(int fingerprintScanningColor) {
        this.fingerprint.fingerprintScanningColor(fingerprintScanningColor);
        return this;
    }

    public FingerprintDialog fingerprintSuccessColor(int fingerprintSuccessColor) {
        this.fingerprint.fingerprintSuccessColor(fingerprintSuccessColor);
        return this;
    }

    public FingerprintDialog fingerprintErrorColor(int fingerprintErrorColor) {
        this.fingerprint.fingerprintErrorColor(fingerprintErrorColor);
        return this;
    }

    public FingerprintDialog circleScanningColor(int circleScanningColor) {
        this.fingerprint.circleScanningColor(circleScanningColor);
        return this;
    }

    public FingerprintDialog circleSuccessColor(int circleSuccessColor) {
        this.fingerprint.circleSuccessColor(circleSuccessColor);
        return this;
    }

    public FingerprintDialog circleErrorColor(int circleErrorColor) {
        this.fingerprint.circleErrorColor(circleErrorColor);
        return this;
    }

    public FingerprintDialog statusScanningColor(int statusScanningColor) {
        this.statusScanningColor = statusScanningColor;
        return this;
    }

    public FingerprintDialog statusSuccessColor(int statusSuccessColor) {
        this.statusSuccessColor = statusSuccessColor;
        return this;
    }

    public FingerprintDialog statusErrorColor(int statusErrorColor) {
        this.statusErrorColor = statusErrorColor;
        return this;
    }

    public FingerprintDialog delayAfterError(int delayAfterError) {
        this.delayAfterError = delayAfterError;
        this.fingerprint.delayAfterError(delayAfterError);
        return this;
    }

    public FingerprintDialog delayAfterSuccess(int delayAfterSuccess) {
        this.delayAfterSuccess = delayAfterSuccess;
        return this;
    }

    public FingerprintDialog tryLimit(int limit, FailAuthCounterCallback counterCallback) {
        this.fingerprint.tryLimit(limit, counterCallback);
        return this;
    }

    public FingerprintDialog usePasswordButton(View.OnClickListener onUsePassword) {
        this.onUsePassword = onUsePassword;
        return this;
    }

    public void show() {
        if (this.title == null || this.message == null) {
            throw new RuntimeException("Title or message cannot be null.");
        }
        this.showDialog();
    }

    private void showDialog() {
        this.dialogTitle.setText((CharSequence)this.title);
        this.dialogMessage.setText((CharSequence)this.message);
        this.cancelButton.setText(R.string.fingerprint_cancel);
        this.usePasswordButton.setText(R.string.fingerprint_use_password);
        this.setStatus(R.string.fingerprint_state_scanning, this.statusScanningColor);
        this.builder.setView(this.dialogView);
        this.dialog = this.builder.create();
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FingerprintDialog.this.fingerprint.cancel();
                if (FingerprintDialog.this.fingerprintDialogSecureCallback != null) {
                    FingerprintDialog.this.fingerprintDialogSecureCallback.onAuthenticationCancel();
                } else {
                    FingerprintDialog.this.fingerprintDialogCallback.onAuthenticationCancel();
                }
                FingerprintDialog.this.dialog.cancel();
            }
        });
        if (this.onUsePassword == null) {
            this.usePasswordButton.setVisibility(8);
        } else {
            this.usePasswordButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    FingerprintDialog.this.fingerprint.cancel();
                    FingerprintDialog.this.dialog.cancel();
                    FingerprintDialog.this.onUsePassword.onClick(view);
                }
            });
        }
        if (this.dialog.getWindow() != null) {
            if (this.enterAnimation != DialogAnimation.Enter.APPEAR || this.exitAnimation != DialogAnimation.Exit.DISAPPEAR) {
                int style2 = DialogAnimation.getStyle(this.enterAnimation, this.exitAnimation);
                if (style2 != -1) {
                    this.dialog.getWindow().getAttributes().windowAnimations = style2;
                } else {
                    Log.w((String)TAG, (String)"The animation selected is not available. Default animation will be used.");
                }
            }
            if (!this.dimBackground) {
                this.dialog.getWindow().clearFlags(2);
            }
        }
        this.dialog.setCanceledOnTouchOutside(this.cancelOnTouchOutside);
        this.dialog.setCancelable(this.cancelOnPressBack);
        this.dialog.show();
        this.authenticate();
    }

    private void authenticate() {
        this.fingerprint.authenticate();
    }

    private void setStatus(int textId, int textColorId) {
        this.setStatus(this.context.getResources().getString(textId), textColorId);
    }

    private void setStatus(String text, int textColorId) {
        this.dialogStatus.setTextColor(ResourcesCompat.getColor((Resources)this.context.getResources(), (int)textColorId, (Resources.Theme)this.context.getTheme()));
        this.dialogStatus.setText((CharSequence)text);
    }
}

