/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BasePIMBridge;
import me.adaptive.arp.api.Email;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IMail;
import me.adaptive.arp.api.IMessagingCallback;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.MessagingCallbackImpl;

public class MailBridge
extends BasePIMBridge
implements IMail,
APIBridge {
    private IMail delegate;

    public MailBridge(IMail delegate) {
        this.delegate = delegate;
    }

    public final IMail getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IMail delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sendEmail(Email data, IMessagingCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing sendEmail...");
        }
        if (this.delegate != null) {
            this.delegate.sendEmail(data, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'sendEmail' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'sendEmail'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "sendEmail": {
                Email data0 = (Email)this.getJSONParser().fromJson(request.getParameters()[0], Email.class);
                MessagingCallbackImpl callback0 = new MessagingCallbackImpl(request.getAsyncId());
                this.sendEmail(data0, callback0);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "MailBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.4.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

