/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseCommunicationBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.ITelephony;
import me.adaptive.arp.api.ITelephonyStatus;
import me.adaptive.arp.api.LoggingBridge;

public class TelephonyBridge
extends BaseCommunicationBridge
implements ITelephony,
APIBridge {
    private ITelephony delegate;

    public TelephonyBridge(ITelephony delegate) {
        this.delegate = delegate;
    }

    public final ITelephony getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(ITelephony delegate) {
        this.delegate = delegate;
    }

    @Override
    public ITelephonyStatus call(String number) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing call...");
        }
        ITelephonyStatus result = null;
        if (this.delegate != null) {
            result = this.delegate.call(number);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'call' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'call'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "call": {
                String number0 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                ITelephonyStatus response0 = this.call(number0);
                if (response0 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response0);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "TelephonyBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

