/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BasePIMBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IMessaging;
import me.adaptive.arp.api.IMessagingCallback;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.MessagingCallbackImpl;

public class MessagingBridge
extends BasePIMBridge
implements IMessaging,
APIBridge {
    private IMessaging delegate;

    public MessagingBridge(IMessaging delegate) {
        this.delegate = delegate;
    }

    public final IMessaging getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IMessaging delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sendSMS(String number, String text, IMessagingCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing sendSMS...");
        }
        if (this.delegate != null) {
            this.delegate.sendSMS(number, text, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'sendSMS' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'sendSMS'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "sendSMS": {
                String number0 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                String text0 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                MessagingCallbackImpl callback0 = new MessagingCallbackImpl(request.getAsyncId());
                this.sendSMS(number0, text0, callback0);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "MessagingBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

