/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseApplicationBridge;
import me.adaptive.arp.api.ILifecycle;
import me.adaptive.arp.api.ILifecycleListener;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LifecycleListenerImpl;
import me.adaptive.arp.api.LoggingBridge;

public class LifecycleBridge
extends BaseApplicationBridge
implements ILifecycle,
APIBridge {
    private ILifecycle delegate;

    public LifecycleBridge(ILifecycle delegate) {
        this.delegate = delegate;
    }

    public final ILifecycle getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(ILifecycle delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addLifecycleListener(ILifecycleListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addLifecycleListener...");
        }
        if (this.delegate != null) {
            this.delegate.addLifecycleListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addLifecycleListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addLifecycleListener'.");
        }
    }

    @Override
    public boolean isBackground() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isBackground...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.isBackground();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isBackground' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isBackground'.");
        }
        return result;
    }

    @Override
    public void removeLifecycleListener(ILifecycleListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeLifecycleListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeLifecycleListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeLifecycleListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeLifecycleListener'.");
        }
    }

    @Override
    public void removeLifecycleListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeLifecycleListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeLifecycleListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeLifecycleListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeLifecycleListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addLifecycleListener": {
                LifecycleListenerImpl listener0 = new LifecycleListenerImpl(request.getAsyncId());
                this.addLifecycleListener(listener0);
                break;
            }
            case "isBackground": {
                boolean response1 = this.isBackground();
                responseJSON = this.getJSONParser().toJson((Object)response1);
                break;
            }
            case "removeLifecycleListener": {
                LifecycleListenerImpl listener2 = new LifecycleListenerImpl(request.getAsyncId());
                this.removeLifecycleListener(listener2);
                break;
            }
            case "removeLifecycleListeners": {
                this.removeLifecycleListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "LifecycleBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

